/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments;

import com.fasterxml.jackson.databind.SerializationConfig;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;

public abstract class AbstractArgumentsMapperCreator {
    protected boolean isSwaggerBodyField = false;
    protected SerializationConfig serializationConfig;
    protected Map<Class<?>, ContextArgumentMapperFactory> contextFactorys;
    protected Method providerMethod;
    protected Class<?> providerClass;
    protected SwaggerOperation swaggerOperation;
    protected List<ArgumentMapper> mappers = new ArrayList<ArgumentMapper>();
    protected List<Parameter> swaggerParameters;
    protected RequestBody bodyParameter;
    protected Map<String, Schema> swaggerBodyProperties;
    protected Set<String> processedSwaggerParameters;

    public AbstractArgumentsMapperCreator(SerializationConfig serializationConfig, Map<Class<?>, ContextArgumentMapperFactory> contextFactorys, Class<?> providerClass, Method providerMethod, SwaggerOperation swaggerOperation) {
        this.serializationConfig = serializationConfig;
        this.contextFactorys = contextFactorys;
        this.providerClass = providerClass;
        this.providerMethod = providerMethod;
        this.swaggerOperation = swaggerOperation;
        this.swaggerParameters = this.swaggerOperation.getOperation().getParameters();
        this.bodyParameter = this.swaggerOperation.getOperation().getRequestBody();
        this.swaggerBodyProperties = this.readSwaggerBodyProperties();
        this.processedSwaggerParameters = new HashSet<String>();
    }

    private Map<String, Schema> readSwaggerBodyProperties() {
        if (this.bodyParameter == null || this.bodyParameter.getContent() == null || this.bodyParameter.getContent().size() == 0) {
            return null;
        }
        if (this.bodyParameter.getContent().get((Object)"multipart/form-data") != null || this.bodyParameter.getContent().get((Object)"application/x-www-form-urlencoded") != null) {
            return null;
        }
        Schema schema = ((MediaType)((Map.Entry)this.bodyParameter.getContent().entrySet().iterator().next()).getValue()).getSchema();
        if (schema != null && schema.get$ref() != null) {
            schema = SwaggerUtils.getSchema((OpenAPI)this.swaggerOperation.getSwagger(), (String)schema.get$ref());
        }
        if (schema != null && schema.getProperties() != null) {
            return schema.getProperties();
        }
        return null;
    }

    protected void doCreateArgumentsMapper() {
        java.lang.reflect.Parameter[] providerParameters = this.providerMethod.getParameters();
        for (int providerParamIdx = 0; providerParamIdx < providerParameters.length; ++providerParamIdx) {
            java.lang.reflect.Parameter providerParameter = providerParameters[providerParamIdx];
            if (this.processContextParameter(providerParameter)) continue;
            String parameterName = SwaggerGeneratorUtils.collectParameterName((java.lang.reflect.Parameter)providerParameter);
            if (this.processKnownParameter(providerParamIdx, parameterName)) {
                this.processedSwaggerParameters.add(parameterName);
                continue;
            }
            if (this.processSwaggerBodyField(providerParamIdx, parameterName)) {
                this.processedSwaggerParameters.add(parameterName);
                this.isSwaggerBodyField = true;
                continue;
            }
            if (this.processBeanParameter(providerParamIdx, providerParameter)) continue;
            this.processUnknownParameter(providerParamIdx, providerParameter, parameterName);
        }
        if (this.swaggerParameters != null) {
            for (Parameter parameter : this.swaggerParameters) {
                if (this.processedSwaggerParameters.contains(parameter.getName())) continue;
                this.processPendingSwaggerParameter(parameter);
            }
        }
        if (this.bodyParameter != null) {
            this.processPendingBodyParameter(this.bodyParameter);
        }
    }

    protected boolean processContextParameter(java.lang.reflect.Parameter providerParameter) {
        ContextArgumentMapperFactory contextFactory = this.contextFactorys.get(providerParameter.getType());
        if (contextFactory == null) {
            return false;
        }
        this.mappers.add(contextFactory.create(providerParameter.getName(), providerParameter.getName()));
        return true;
    }

    protected boolean processKnownParameter(int providerParamIdx, String invocationArgumentName) {
        if (!this.parameterNameExistsInSwagger(invocationArgumentName)) {
            return false;
        }
        ArgumentMapper mapper = this.createKnownParameterMapper(providerParamIdx, invocationArgumentName);
        this.mappers.add(mapper);
        return true;
    }

    protected boolean parameterNameExistsInSwagger(String parameterName) {
        if (this.swaggerParameters != null) {
            for (Parameter parameter : this.swaggerParameters) {
                if (!parameterName.equals(parameter.getName())) continue;
                return true;
            }
        }
        if (this.bodyParameter != null && this.bodyParameter.getContent() != null) {
            if (this.bodyParameter.getContent().get((Object)"application/x-www-form-urlencoded") != null && ((MediaType)this.bodyParameter.getContent().get((Object)"application/x-www-form-urlencoded")).getSchema() != null && ((MediaType)this.bodyParameter.getContent().get((Object)"application/x-www-form-urlencoded")).getSchema().getProperties() != null) {
                return ((MediaType)this.bodyParameter.getContent().get((Object)"application/x-www-form-urlencoded")).getSchema().getProperties().get(parameterName) != null;
            }
            if (this.bodyParameter.getContent().get((Object)"multipart/form-data") != null && ((MediaType)this.bodyParameter.getContent().get((Object)"multipart/form-data")).getSchema() != null && ((MediaType)this.bodyParameter.getContent().get((Object)"multipart/form-data")).getSchema().getProperties() != null) {
                return ((MediaType)this.bodyParameter.getContent().get((Object)"multipart/form-data")).getSchema().getProperties().get(parameterName) != null;
            }
        }
        if (this.bodyParameter != null && this.bodyParameter.getExtensions() != null) {
            return parameterName.equals(this.bodyParameter.getExtensions().get("x-name"));
        }
        return false;
    }

    protected abstract ArgumentMapper createKnownParameterMapper(int var1, String var2);

    protected boolean processSwaggerBodyField(int providerParamIdx, String parameterName) {
        if (this.swaggerBodyProperties == null || this.swaggerBodyProperties.get(parameterName) == null) {
            return false;
        }
        ArgumentMapper mapper = this.createSwaggerBodyFieldMapper(providerParamIdx, parameterName);
        this.mappers.add(mapper);
        return true;
    }

    protected abstract ArgumentMapper createSwaggerBodyFieldMapper(int var1, String var2);

    protected abstract boolean processBeanParameter(int var1, java.lang.reflect.Parameter var2);

    protected abstract void processUnknownParameter(int var1, java.lang.reflect.Parameter var2, String var3);

    protected abstract void processPendingSwaggerParameter(Parameter var1);

    protected abstract void processPendingBodyParameter(RequestBody var1);
}

