/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Tracing;
import brave.context.slf4j.MDCScopeDecorator;
import brave.handler.SpanHandler;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalCurrentTraceContext;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.DynamicProperties;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.tracing.zipkin.CustomHttpRequestParser;
import org.apache.servicecomb.tracing.zipkin.CustomHttpResponseParser;
import org.apache.servicecomb.tracing.zipkin.LogSpanHandler;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SpanBytesEncoder;
import zipkin2.reporter.brave.AsyncZipkinSpanHandler;
import zipkin2.reporter.okhttp3.OkHttpSender;

@Configuration
@ConditionalOnProperty(value={"servicecomb.tracing.enabled"}, havingValue="true", matchIfMissing=true)
public class TracingConfiguration {
    public static final String TRACING_PREFIX = "servicecomb.tracing";
    public static final String TRACING_ENABLED = "servicecomb.tracing.enabled";
    public static final String TRACING_REPORTER_LOG_ENABLED = "servicecomb.tracing.reporter.log.enabled";
    public static final String TRACING_REPORTER_ZIPKIN_ENABLED = "servicecomb.tracing.reporter.zipkin.enabled";

    @Bean
    CurrentTraceContext currentTraceContext() {
        return ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator(MDCScopeDecorator.newBuilder().build()).build();
    }

    @Bean
    Tracing tracing(@Autowired(required=false) Sender sender, CurrentTraceContext currentTraceContext, Environment environment, DynamicProperties dynamicProperties) {
        Tracing.Builder builder = Tracing.newBuilder().localServiceName(BootStrapProperties.readServiceName((Environment)environment)).currentTraceContext(currentTraceContext);
        if (dynamicProperties.getBooleanProperty(TRACING_REPORTER_LOG_ENABLED, true)) {
            builder.addSpanHandler((SpanHandler)new LogSpanHandler());
        }
        if (dynamicProperties.getBooleanProperty(TRACING_REPORTER_ZIPKIN_ENABLED, false)) {
            builder.addSpanHandler((SpanHandler)AsyncZipkinSpanHandler.create((Sender)sender));
        }
        return builder.build();
    }

    @Bean
    HttpTracing httpTracing(Tracing tracing) {
        return HttpTracing.newBuilder((Tracing)tracing).clientRequestParser((HttpRequestParser)new CustomHttpRequestParser()).clientResponseParser((HttpResponseParser)new CustomHttpResponseParser()).serverRequestParser((HttpRequestParser)new CustomHttpRequestParser()).serverResponseParser((HttpResponseParser)new CustomHttpResponseParser()).build();
    }

    @Bean
    ZipkinTracingFilter zipkinTracingFilter() {
        return new ZipkinTracingFilter();
    }

    public static String createRequestPath(Invocation invocation) {
        URIEndpointObject address = (URIEndpointObject)invocation.getEndpoint().getAddress();
        String urlPrefix = address.getFirst("urlPrefix");
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        String path = (String)invocation.getHandlerContext().get("rest-client-request-path");
        if (path == null) {
            try {
                path = swaggerRestOperation.getPathBuilder().createRequestPath(invocation.getSwaggerArguments());
            }
            catch (Exception e) {
                path = invocation.getOperationMeta().getOperationPath();
            }
        }
        if (StringUtils.isEmpty((CharSequence)urlPrefix) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }

    @Configuration
    @ConditionalOnProperty(value={"servicecomb.tracing.reporter.zipkin.enabled"}, havingValue="true")
    static class ZipkinReporterConfiguration {
        ZipkinReporterConfiguration() {
        }

        @Bean
        BytesMessageSender okHttpSender(DynamicProperties dynamicProperties) {
            String apiVersion = dynamicProperties.getStringProperty("servicecomb.tracing.collector.apiVersion", "v2").toLowerCase();
            if (apiVersion.compareTo("v1") != 0) {
                apiVersion = "v2";
            }
            String path = MessageFormat.format("/api/{0}/spans", apiVersion);
            return OkHttpSender.create((String)dynamicProperties.getStringProperty("servicecomb.tracing.collector.address", "http://127.0.0.1:9411").trim().replaceAll("/+$", "").concat(path));
        }

        @Bean
        Reporter<Span> zipkinReporter(DynamicProperties dynamicProperties, BytesMessageSender sender) {
            String apiVersion = dynamicProperties.getStringProperty("servicecomb.tracing.collector.apiVersion", "v2").toLowerCase();
            if (apiVersion.compareTo("v1") == 0) {
                return AsyncReporter.builder((BytesMessageSender)sender).build((BytesEncoder)SpanBytesEncoder.JSON_V1);
            }
            return AsyncReporter.builder((BytesMessageSender)sender).build();
        }
    }
}

