/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import jakarta.ws.rs.core.Response;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProducerInvocationFlow {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerInvocationFlow.class);
    private final long startTime = System.nanoTime();
    private final InvocationCreator invocationCreator;
    protected final HttpServletRequestEx requestEx;
    protected final HttpServletResponseEx responseEx;

    public ProducerInvocationFlow(InvocationCreator invocationCreator) {
        this(invocationCreator, null, null);
    }

    public ProducerInvocationFlow(InvocationCreator invocationCreator, HttpServletRequestEx requestEx, HttpServletResponseEx responseEx) {
        this.invocationCreator = invocationCreator;
        this.requestEx = requestEx;
        this.responseEx = responseEx;
    }

    public void run() {
        ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(v -> this.invocationCreator.createAsync())).exceptionally(this::sendCreateInvocationException)).thenAccept(this::tryRunInvocation);
    }

    private void tryRunInvocation(Invocation invocation) {
        if (invocation == null) {
            return;
        }
        invocation.getInvocationStageTrace().startCreateInvocation(this.startTime);
        invocation.getInvocationStageTrace().finishCreateInvocation();
        invocation.onStart(this.requestEx);
        if (invocation.isEdge()) {
            invocation.getMicroserviceMeta().getEdgeFilterChain().onFilter(invocation).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Maybe a fatal bug that should be addressed.", throwable);
                    response = Response.createFail((InvocationException)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)new CommonExceptionData("Internal error, check logs for details.")));
                }
                this.endResponse(invocation, (Response)response);
                this.finishInvocation(invocation, (Response)response);
            });
            return;
        }
        invocation.getMicroserviceMeta().getProviderFilterChain().onFilter(invocation).whenComplete((response, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Maybe a fatal bug that should be addressed.", throwable);
                response = Response.createFail((InvocationException)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)new CommonExceptionData("Internal error, check logs for details.")));
            }
            this.endResponse(invocation, (Response)response);
            this.finishInvocation(invocation, (Response)response);
        });
    }

    private void finishInvocation(Invocation invocation, Response response) {
        invocation.onFinish(response);
    }

    protected abstract Invocation sendCreateInvocationException(Throwable var1);

    protected abstract void endResponse(Invocation var1, Response var2);
}

