/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.executor.GroupThreadFactory;
import org.apache.servicecomb.core.executor.LinkedBlockingQueueEx;
import org.apache.servicecomb.core.executor.ThreadPoolExecutorEx;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class GroupExecutor
implements Executor,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupExecutor.class);
    public static final String KEY_GROUP = "servicecomb.executor.default.group";
    public static final String KEY_OLD_MAX_THREAD = "servicecomb.executor.default.thread-per-group";
    public static final String KEY_CORE_THREADS = "servicecomb.executor.default.coreThreads-per-group";
    public static final String KEY_MAX_THREADS = "servicecomb.executor.default.maxThreads-per-group";
    public static final String KEY_MAX_IDLE_SECOND = "servicecomb.executor.default.maxIdleSecond-per-group";
    public static final String KEY_MAX_QUEUE_SIZE = "servicecomb.executor.default.maxQueueSize-per-group";
    private static final AtomicBoolean LOG_PRINTED = new AtomicBoolean();
    private final Environment environment;
    protected String groupName;
    protected int groupCount;
    protected int coreThreads;
    protected int maxThreads;
    protected int maxIdleInSecond;
    protected int maxQueueSize;
    private final List<ExecutorService> executorList = new ArrayList<ExecutorService>();
    private final AtomicInteger index = new AtomicInteger();
    private final Map<Long, Executor> threadExecutorMap = new ConcurrentHashMapEx();

    public GroupExecutor(Environment environment) {
        this.environment = environment;
    }

    public GroupExecutor init() {
        return this.init("group");
    }

    public GroupExecutor init(String groupName) {
        this.groupName = groupName;
        this.initConfig();
        for (int groupIdx = 0; groupIdx < this.groupCount; ++groupIdx) {
            GroupThreadFactory factory = new GroupThreadFactory(groupName + groupIdx);
            ThreadPoolExecutorEx executor = new ThreadPoolExecutorEx(this.coreThreads, this.maxThreads, this.maxIdleInSecond, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueueEx(this.maxQueueSize), (ThreadFactory)factory);
            this.executorList.add(executor);
        }
        return this;
    }

    public void initConfig() {
        if (LOG_PRINTED.compareAndSet(false, true)) {
            LOGGER.info("thread pool rules:\n1.use core threads.\n2.if all core threads are busy, then create new thread.\n3.if thread count reach the max limitation, then queue the request.\n4.if queue is full, and threads count is max, then reject the request.");
        }
        this.groupCount = (Integer)this.environment.getProperty(KEY_GROUP, Integer.TYPE, (Object)2);
        this.coreThreads = (Integer)this.environment.getProperty(KEY_CORE_THREADS, Integer.TYPE, (Object)25);
        this.maxThreads = (Integer)this.environment.getProperty(KEY_MAX_THREADS, Integer.TYPE, (Object)-1);
        if (this.maxThreads <= 0) {
            this.maxThreads = (Integer)this.environment.getProperty(KEY_OLD_MAX_THREAD, Integer.TYPE, (Object)-1);
            if (this.maxThreads > 0) {
                LOGGER.warn("{} is deprecated, recommended to use {}.", (Object)KEY_OLD_MAX_THREAD, (Object)KEY_MAX_THREADS);
            } else {
                this.maxThreads = 100;
            }
        }
        if (this.coreThreads > this.maxThreads) {
            LOGGER.warn("coreThreads is bigger than maxThreads, change from {} to {}.", (Object)this.coreThreads, (Object)this.maxThreads);
            this.coreThreads = this.maxThreads;
        }
        this.maxIdleInSecond = (Integer)this.environment.getProperty(KEY_MAX_IDLE_SECOND, Integer.TYPE, (Object)60);
        this.maxQueueSize = (Integer)this.environment.getProperty(KEY_MAX_QUEUE_SIZE, Integer.TYPE, (Object)Integer.MAX_VALUE);
        LOGGER.info("executor name={}, group={}. per group settings, coreThreads={}, maxThreads={}, maxIdleInSecond={}, maxQueueSize={}.", new Object[]{this.groupName, this.groupCount, this.coreThreads, this.maxThreads, this.maxIdleInSecond, this.maxQueueSize});
    }

    public List<ExecutorService> getExecutorList() {
        return this.executorList;
    }

    @Override
    public void execute(Runnable command) {
        long threadId = Thread.currentThread().getId();
        Executor executor = this.threadExecutorMap.computeIfAbsent(threadId, this::chooseExecutor);
        executor.execute(command);
    }

    private Executor chooseExecutor(long threadId) {
        int idx = this.index.getAndIncrement() % this.executorList.size();
        return this.executorList.get(idx);
    }

    @Override
    public void close() {
        for (ExecutorService executorService : this.executorList) {
            executorService.shutdown();
        }
        this.executorList.clear();
    }
}

