/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.nacos;

import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.nacos.NacosDiscoveryInstance;
import org.apache.servicecomb.registry.nacos.NacosDiscoveryProperties;
import org.apache.servicecomb.registry.nacos.NamingServiceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class NacosDiscovery
implements Discovery<NacosDiscoveryInstance> {
    public static final String NACOS_DISCOVERY_ENABLED = "servicecomb.registry.nacos.%s.%s.enabled";
    private static final Map<String, Map<String, AtomicBoolean>> SUBSCRIBES = new HashMap<String, Map<String, AtomicBoolean>>();
    private final Object lock = new Object();
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private Environment environment;
    private NamingService namingService;
    private Discovery.InstanceChangedListener<NacosDiscoveryInstance> instanceChangedListener;

    @Autowired
    public NacosDiscovery(NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String name() {
        return "nacos-registry";
    }

    public boolean enabled(String application, String serviceName) {
        return (Boolean)this.environment.getProperty(String.format(NACOS_DISCOVERY_ENABLED, application, serviceName), Boolean.TYPE, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NacosDiscoveryInstance> findServiceInstances(String application, String serviceName) {
        try {
            AtomicBoolean result = SUBSCRIBES.computeIfAbsent(application, k -> new HashMap()).computeIfAbsent(serviceName, k -> new AtomicBoolean(true));
            if (result.get()) {
                Object object = this.lock;
                synchronized (object) {
                    if (result.get()) {
                        this.namingService.subscribe(serviceName, application, event -> {
                            if (result.getAndSet(false)) {
                                return;
                            }
                            if (event instanceof NamingEvent) {
                                this.instanceChangedListener.onInstanceChanged(this.name(), application, serviceName, this.convertServiceInstanceList(((NamingEvent)event).getInstances(), application, serviceName));
                            }
                        });
                    }
                }
            }
            List instances = this.namingService.getAllInstances(serviceName, application, true);
            return this.convertServiceInstanceList(instances, application, serviceName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<NacosDiscoveryInstance> convertServiceInstanceList(List<Instance> instances, String application, String serviceName) {
        if (CollectionUtils.isEmpty(instances)) {
            return Collections.emptyList();
        }
        ArrayList<NacosDiscoveryInstance> result = new ArrayList<NacosDiscoveryInstance>();
        for (Instance instance : instances) {
            result.add(new NacosDiscoveryInstance(instance, application, serviceName, this.environment));
        }
        return result;
    }

    public void setInstanceChangedListener(Discovery.InstanceChangedListener<NacosDiscoveryInstance> instanceChangedListener) {
        this.instanceChangedListener = instanceChangedListener;
    }

    public void init() {
        this.namingService = NamingServiceManager.buildNamingService(this.environment, this.nacosDiscoveryProperties);
    }

    public void run() {
    }

    public void destroy() {
    }

    public boolean enabled() {
        return this.nacosDiscoveryProperties.isEnabled();
    }
}

