/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.apache.servicecomb.http.client.common.URLEndPoint;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAddressManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAddressManager.class);
    public static final String DEFAULT_PROJECT = "default";
    public static final String V4_PREFIX = "/v4/";
    private static final String V3_PREFIX = "/v3/";
    private static final int DEFAULT_METRICS_WINDOW_TIME = 1;
    private static final int ISOLATION_THRESHOLD = 3;
    private List<String> addresses = new ArrayList<String>();
    private int index;
    private String projectName;
    private final Map<String, Boolean> addressCategory = new HashMap<String, Boolean>();
    private final Map<String, Integer> addressFailureStatus = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Boolean> addressIsolated = new ConcurrentHashMap<String, Boolean>();
    private Cache<String, Boolean> addressIsolationStatus = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private volatile List<String> availableZone = new ArrayList<String>();
    private volatile List<String> availableRegion = new ArrayList<String>();
    private final List<String> defaultAddress = new ArrayList<String>();
    private boolean addressAutoRefreshed = false;
    private final Object lock = new Object();
    private Random random = new Random();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("check-available-address-%d").build());

    public AbstractAddressManager(List<String> addresses) {
        this.projectName = DEFAULT_PROJECT;
        this.addresses.addAll(addresses);
        this.defaultAddress.addAll(addresses);
        this.index = addresses.size() > 0 ? this.random.nextInt(addresses.size()) : 0;
    }

    public AbstractAddressManager(String projectName, List<String> addresses) {
        this.projectName = StringUtils.isEmpty((CharSequence)projectName) ? DEFAULT_PROJECT : projectName;
        this.addresses = this.transformAddress(addresses);
        this.defaultAddress.addAll(this.addresses);
        this.index = addresses.size() > 0 ? this.random.nextInt(addresses.size()) : 0;
    }

    @VisibleForTesting
    Cache<String, Boolean> getAddressIsolationStatus() {
        return this.addressIsolationStatus;
    }

    @VisibleForTesting
    void setAddressIsolationStatus(Cache<String, Boolean> addressIsolationStatus) {
        this.addressIsolationStatus = addressIsolationStatus;
    }

    @VisibleForTesting
    Map<String, Integer> getAddressFailureStatus() {
        return this.addressFailureStatus;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public List<String> getAvailableZone() {
        return this.availableZone;
    }

    public List<String> getAvailableRegion() {
        return this.availableRegion;
    }

    private void startCheck() {
        this.executorService.scheduleAtFixedRate(this::checkHistory, 0L, 1L, TimeUnit.MINUTES);
    }

    public String formatUrl(String url, boolean absoluteUrl, String address) {
        return absoluteUrl ? address + url : this.formatAddress(address) + url;
    }

    public String address() {
        if (!this.addressAutoRefreshed) {
            return this.getDefaultAddress();
        }
        return this.getAvailableZoneAddress();
    }

    public boolean sslEnabled() {
        return this.address().startsWith("https://");
    }

    protected List<String> transformAddress(List<String> addresses) {
        return addresses.stream().map(this::formatAddress).collect(Collectors.toList());
    }

    protected String getUrlPrefix(String address) {
        return address + V3_PREFIX;
    }

    protected String formatAddress(String address) {
        try {
            return this.getUrlPrefix(address) + HttpUtils.encodeURLParam(this.projectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("not possible");
        }
    }

    private String getDefaultAddress() {
        List<String> addresses = this.getAvailableAddress(this.defaultAddress);
        if (!addresses.isEmpty()) {
            return this.getCurrentAddress(addresses);
        }
        return this.getInitAddress();
    }

    private String getAvailableZoneAddress() {
        List<String> addresses = this.getAvailableZoneIpPorts();
        if (!addresses.isEmpty()) {
            return this.getCurrentAddress(addresses);
        }
        return this.getInitAddress();
    }

    private String getInitAddress() {
        if (this.addresses.isEmpty()) {
            return null;
        }
        return this.getCurrentAddress(this.addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentAddress(List<String> addresses) {
        AbstractAddressManager abstractAddressManager = this;
        synchronized (abstractAddressManager) {
            ++this.index;
            if (this.index >= addresses.size()) {
                this.index = 0;
            }
            return addresses.get(this.index);
        }
    }

    private List<String> getAvailableZoneIpPorts() {
        ArrayList<String> results = new ArrayList<String>();
        if (!this.availableZone.isEmpty()) {
            results.addAll(this.getAvailableAddress(this.availableZone));
        } else {
            results.addAll(this.getAvailableAddress(this.availableRegion));
        }
        return results;
    }

    private List<String> getAvailableAddress(List<String> endpoints) {
        return endpoints.stream().filter(uri -> !this.addressIsolated.containsKey(uri) || this.addressIsolated.get(uri) != false).collect(Collectors.toList());
    }

    protected String normalizeUri(String endpoint) {
        return new URLEndPoint(endpoint).toString();
    }

    public void refreshEndpoint(RefreshEndpointEvent event, String key) {
        if (null == event || !event.getName().equals(key)) {
            return;
        }
        this.availableZone = event.getSameZone().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.availableRegion = event.getSameRegion().stream().map(this::normalizeUri).collect(Collectors.toList());
        this.availableZone.forEach(address -> this.addressCategory.put((String)address, true));
        this.availableRegion.forEach(address -> this.addressCategory.put((String)address, false));
        this.startCheck();
        this.addressAutoRefreshed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFailState(String address) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.addressFailureStatus.containsKey(address)) {
                this.addressFailureStatus.put(address, 1);
                return;
            }
            int number = this.addressFailureStatus.get(address) + 1;
            if (number < 3) {
                this.addressFailureStatus.put(address, number);
            } else {
                this.removeAddress(address);
            }
        }
    }

    public void recordSuccessState(String address) {
        this.addressFailureStatus.put(address, 0);
    }

    @VisibleForTesting
    protected void checkHistory() {
        this.addressIsolated.keySet().stream().filter(this::judgeIsolation).forEach(s -> {
            if (this.telnetTest((String)s)) {
                this.rejoinAddress((String)s);
            } else {
                this.addressIsolationStatus.put(s, (Object)false);
            }
        });
    }

    private Boolean judgeIsolation(String address) {
        try {
            return (Boolean)this.addressIsolationStatus.get((Object)address, () -> true);
        }
        catch (ExecutionException e) {
            return true;
        }
    }

    protected boolean telnetTest(String address) {
        boolean bl;
        URI ipPort = this.parseIpPortFromURI(address);
        Socket s = new Socket();
        try {
            s.connect(new InetSocketAddress(ipPort.getHost(), ipPort.getPort()), 3000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("ping endpoint {} failed, It will be quarantined again.", (Object)address);
                return false;
            }
        }
        s.close();
        return bl;
    }

    private URI parseIpPortFromURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @VisibleForTesting
    void rejoinAddress(String address) {
        if (!this.addressAutoRefreshed) {
            this.defaultAddress.add(address);
            this.addressFailureStatus.put(address, 0);
            this.addressIsolated.remove(address);
            return;
        }
        if (this.addressCategory.get(address) == null) {
            LOGGER.warn("may not happen {}-{}", (Object)this.addressCategory.size(), (Object)address);
            return;
        }
        if (this.addressCategory.get(address).booleanValue()) {
            this.availableZone.add(address);
        } else {
            this.availableRegion.add(address);
        }
        this.addressFailureStatus.put(address, 0);
        this.addressIsolated.remove(address);
    }

    @VisibleForTesting
    void removeAddress(String address) {
        if (!this.addressAutoRefreshed) {
            this.defaultAddress.remove(address);
            this.addressIsolated.put(address, false);
            this.addressIsolationStatus.put((Object)address, (Object)false);
            return;
        }
        if (this.addressCategory.get(address) == null) {
            LOGGER.warn("may not happen {}-{}", (Object)this.addressCategory.size(), (Object)address);
            return;
        }
        if (this.addressCategory.get(address).booleanValue()) {
            this.availableZone.remove(address);
        } else {
            this.availableRegion.remove(address);
        }
        this.addressIsolated.put(address, false);
        this.addressIsolationStatus.put((Object)address, (Object)false);
    }
}

