/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.codec.query.QueryCodecsUtils;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class QueryProcessorCreator
implements ParamValueProcessorCreator<Parameter> {
    public static final String PARAMTYPE = "query";

    public QueryProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(OperationMeta operationMeta, String parameterName, Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new QueryProcessor((QueryParameter)parameter, targetType);
    }

    public static class QueryProcessor
    extends AbstractParamProcessor {
        private final boolean emptyAsNull = LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.parameter.query.emptyAsNull", (boolean)false);
        private final boolean ignoreDefaultValue = LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.parameter.query.ignoreDefaultValue", (boolean)false);
        private final boolean ignoreRequiredCheck = LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.parameter.query.ignoreRequiredCheck", (boolean)false);
        private final boolean repeatedType;
        private final QueryCodec queryCodec;

        public QueryProcessor(QueryParameter queryParameter, JavaType targetType) {
            super(queryParameter.getName(), targetType, queryParameter.getSchema().getDefault(), queryParameter.getRequired() != null && queryParameter.getRequired() != false);
            this.repeatedType = queryParameter.getSchema() instanceof ArraySchema;
            this.queryCodec = QueryCodecsUtils.find(queryParameter.getStyle(), queryParameter.getExplode());
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            return this.queryCodec.decode(this, request);
        }

        public Object getAndCheckParameter(HttpServletRequest request) {
            String value = request.getParameter(this.paramPath);
            if (value == null) {
                Map forms = (Map)request.getAttribute("servicecomb-body");
                String string = value = forms == null || forms.get(this.paramPath) == null ? null : (String)forms.get(this.paramPath);
            }
            if (this.emptyAsNull && "".equals(value)) {
                value = null;
            }
            return value != null ? value : this.checkRequiredAndDefaultValue();
        }

        private Object checkRequiredAndDefaultValue() {
            if (!this.ignoreRequiredCheck && this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, String.format("Parameter %s is required.", this.paramPath));
            }
            Object defaultValue = this.getDefaultValue();
            if (!this.ignoreDefaultValue && defaultValue != null) {
                return defaultValue;
            }
            return null;
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
        }

        @Override
        public String getProcessorType() {
            return QueryProcessorCreator.PARAMTYPE;
        }

        public QueryCodec getQueryCodec() {
            return this.queryCodec;
        }

        public boolean isRepeatedType() {
            return this.repeatedType;
        }

        public Object convertValue(Object value) {
            return this.convertValue(value, this.targetType);
        }
    }
}

