/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.servicecomb.codec.protobuf.utils.ScopedProtobufSchemaManager;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.RootDeserializer;
import org.apache.servicecomb.foundation.protobuf.RootSerializer;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyWrapper;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyProcessorCreator
implements ParamValueProcessorCreator<RequestBody> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyProcessorCreator.class);
    public static final String REQUEST_BODY_NAME = "X_REQUEST";
    public static final String EXT_ID = "protobuf";
    public static final String PARAM_TYPE = "body";
    private static final JavaType OBJECT_TYPE = SimpleType.constructUnsafe(Object.class);
    private static final Object LOCK = new Object();
    public static final String PARAM_DECODE_AS_OBJECT = "servicecomb.rest.parameter.decodeAsObject";
    public static final String PARAM_DEFAULT_REQUEST_ENCODING = "servicecomb.rest.parameter.default-request-encoding";
    private static Boolean decodeAsObject;
    private static String defaultRequestEncoding;

    public BodyProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAM_TYPE, this);
    }

    @Override
    public ParamValueProcessor create(OperationMeta operationMeta, String parameterName, RequestBody parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        boolean rawJson = SwaggerUtils.isRawJsonType((RequestBody)parameter);
        if (rawJson) {
            return new RawJsonBodyProcessor(targetType, (String)parameter.getExtensions().get("x-json-view"), parameter.getRequired() != null && parameter.getRequired() != false);
        }
        return new BodyProcessor(operationMeta, targetType, parameter);
    }

    private static boolean decodeAsObject() {
        if (decodeAsObject == null) {
            decodeAsObject = LegacyPropertyFactory.getBooleanProperty((String)PARAM_DECODE_AS_OBJECT, (boolean)false);
        }
        return decodeAsObject;
    }

    private static String clientEncodingDefault() {
        if (defaultRequestEncoding == null) {
            defaultRequestEncoding = LegacyPropertyFactory.getStringProperty((String)PARAM_DEFAULT_REQUEST_ENCODING, (String)"application/json");
        }
        return defaultRequestEncoding;
    }

    public static class RawJsonBodyProcessor
    implements ParamValueProcessor {
        protected JavaType targetType;
        protected Class<?> serialViewClass;
        protected boolean isRequired;

        public RawJsonBodyProcessor(JavaType targetType, boolean isRequired) {
            this(targetType, null, isRequired);
        }

        public RawJsonBodyProcessor(JavaType targetType, String serialViewClass, boolean isRequired) {
            if (!StringUtils.isEmpty((CharSequence)serialViewClass)) {
                try {
                    this.serialViewClass = Class.forName(serialViewClass);
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to create body processor {}, annotation @JsonView may be invalid", (Object)serialViewClass, (Object)e);
                }
            }
            this.targetType = targetType;
            this.isRequired = isRequired;
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            Object body = request.getAttribute("servicecomb-body");
            if (body != null) {
                return this.convertValue(body, this.targetType);
            }
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream == null) {
                return null;
            }
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            if (arg instanceof String) {
                clientRequest.putHeader("Content-Type", "application/json");
                clientRequest.write(Buffer.buffer((String)((String)arg)));
                return;
            }
            throw new IllegalArgumentException("@RawJsonRequestBody only supports string type.");
        }

        @Override
        public String getParameterPath() {
            return "";
        }

        @Override
        public String getProcessorType() {
            return BodyProcessorCreator.PARAM_TYPE;
        }
    }

    public static class BodyProcessor
    implements ParamValueProcessor {
        protected JavaType targetType;
        protected Class<?> serialViewClass;
        protected boolean isRequired;
        protected OpenAPI openAPI;
        protected ScopedProtobufSchemaManager scopedProtobufSchemaManager;
        protected List<String> supportedContentTypes = new ArrayList<String>();
        protected OperationMeta operationMeta;
        protected RequestBody requestBody;

        public BodyProcessor(OperationMeta operationMeta, JavaType targetType, RequestBody requestBody) {
            this.requestBody = requestBody;
            if (!StringUtils.isEmpty((CharSequence)((String)this.requestBody.getExtensions().get("x-json-view")))) {
                try {
                    this.serialViewClass = Class.forName((String)this.requestBody.getExtensions().get("x-json-view"));
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to create body processor {}, annotation @JsonView may be invalid", this.serialViewClass, (Object)e);
                }
            }
            this.targetType = targetType;
            boolean bl = this.isRequired = this.requestBody.getRequired() != null && this.requestBody.getRequired() != false;
            if (this.requestBody.getContent() != null) {
                this.supportedContentTypes.addAll(this.requestBody.getContent().keySet());
            }
            if (operationMeta != null) {
                this.operationMeta = operationMeta;
                this.openAPI = operationMeta.getSchemaMeta().getSwagger();
                if (this.supportedContentTypes.contains("application/protobuf")) {
                    this.scopedProtobufSchemaManager = this.getOrCreateScopedProtobufSchemaManager(operationMeta.getMicroserviceMeta());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ScopedProtobufSchemaManager getOrCreateScopedProtobufSchemaManager(MicroserviceMeta microserviceMeta) {
            ScopedProtobufSchemaManager scopedProtobufSchemaManager = (ScopedProtobufSchemaManager)microserviceMeta.getExtData(BodyProcessorCreator.EXT_ID);
            if (scopedProtobufSchemaManager == null) {
                Object object = LOCK;
                synchronized (object) {
                    scopedProtobufSchemaManager = (ScopedProtobufSchemaManager)microserviceMeta.getExtData(BodyProcessorCreator.EXT_ID);
                    if (scopedProtobufSchemaManager == null) {
                        scopedProtobufSchemaManager = new ScopedProtobufSchemaManager();
                        microserviceMeta.putExtData(BodyProcessorCreator.EXT_ID, (Object)scopedProtobufSchemaManager);
                    }
                }
            }
            return scopedProtobufSchemaManager;
        }

        @Override
        public Class<?> getSerialViewClass() {
            return this.serialViewClass;
        }

        @Override
        public Object getValue(HttpServletRequest request) throws Exception {
            Object result = this.getValueImpl(request);
            if (result == null && this.isRequired) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Body parameter is required.");
            }
            return result;
        }

        private Object getValueImpl(HttpServletRequest request) throws IOException {
            Object body = request.getAttribute("servicecomb-body");
            if (body != null) {
                return this.convertValue(body, this.targetType);
            }
            String contentType = this.validContentType(request.getContentType());
            if (contentType.equals("multipart/form-data") || contentType.equals("application/x-www-form-urlencoded")) {
                return this.convertValue(request.getParameterMap(), this.targetType);
            }
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream == null) {
                return null;
            }
            if ("application/json".equals(contentType)) {
                try {
                    ObjectReader reader;
                    ObjectReader objectReader = reader = this.serialViewClass != null ? RestObjectMapperFactory.getRestObjectMapper().readerWithView(this.serialViewClass) : RestObjectMapperFactory.getRestObjectMapper().reader();
                    if (BodyProcessorCreator.decodeAsObject()) {
                        return reader.forType(OBJECT_TYPE).readValue((InputStream)inputStream);
                    }
                    return reader.forType(this.targetType == null ? OBJECT_TYPE : this.targetType).readValue((InputStream)inputStream);
                }
                catch (MismatchedInputException e) {
                    if (!this.isRequired && e.getMessage().contains("No content to map due to end-of-input")) {
                        LOGGER.info("Empty content and required is false, taken as null");
                        return null;
                    }
                    throw e;
                }
            }
            if ("application/protobuf".equals(contentType)) {
                ProtoMapper protoMapper = this.scopedProtobufSchemaManager.getOrCreateProtoMapper(this.openAPI, this.operationMeta.getSchemaId(), BodyProcessorCreator.REQUEST_BODY_NAME, ((MediaType)this.requestBody.getContent().get((Object)"application/protobuf")).getSchema());
                RootDeserializer deserializer = protoMapper.getDeserializerSchemaManager().createRootDeserializer(protoMapper.getProto().getMessage(BodyProcessorCreator.REQUEST_BODY_NAME), (Type)(this.targetType == null ? OBJECT_TYPE : this.targetType));
                PropertyWrapper result = (PropertyWrapper)deserializer.deserialize(inputStream.readAllBytes());
                return result.getValue();
            }
            if ("text/plain".equals(contentType)) {
                try {
                    ObjectReader reader;
                    if (this.targetType != null && String.class.equals((Object)this.targetType.getRawClass())) {
                        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    }
                    ObjectReader objectReader = reader = this.serialViewClass != null ? RestObjectMapperFactory.getRestObjectMapper().readerWithView(this.serialViewClass) : RestObjectMapperFactory.getRestObjectMapper().reader();
                    if (BodyProcessorCreator.decodeAsObject()) {
                        return reader.forType(OBJECT_TYPE).readValue((InputStream)inputStream);
                    }
                    return reader.forType(this.targetType == null ? OBJECT_TYPE : this.targetType).readValue((InputStream)inputStream);
                }
                catch (MismatchedInputException e) {
                    if (!this.isRequired && e.getMessage().contains("No content to map due to end-of-input")) {
                        LOGGER.info("Empty content and required is false, taken as null");
                        return null;
                    }
                    throw e;
                }
            }
            throw new IllegalArgumentException(String.format("operation %s not support content-type %s", this.operationMeta.getSchemaQualifiedName(), contentType));
        }

        private String validContentType(String type) {
            if (StringUtils.isEmpty((CharSequence)type)) {
                if (this.supportedContentTypes.size() == 0) {
                    throw new IllegalArgumentException("operation do not have any content type support.");
                }
                if (this.supportedContentTypes.contains(BodyProcessorCreator.clientEncodingDefault())) {
                    return BodyProcessorCreator.clientEncodingDefault();
                }
                return this.supportedContentTypes.get(0);
            }
            ContentType contentType = ContentType.parse((String)type);
            return contentType.getMimeType();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            String userContentType = clientRequest.getHeaders().get("Content-Type");
            String contentType = this.validContentType(userContentType);
            if (StringUtils.isEmpty((CharSequence)userContentType)) {
                clientRequest.putHeader("Content-Type", contentType);
            }
            if (arg != null) {
                Buffer buffer = this.createBodyBuffer(contentType, arg);
                clientRequest.write(buffer);
            }
        }

        private Buffer createBodyBuffer(String contentType, Object arg) throws IOException {
            if ("application/json".equals(contentType)) {
                try (BufferOutputStream output = new BufferOutputStream();){
                    RestObjectMapperFactory.getConsumerWriterMapper().writeValue((OutputStream)output, arg);
                    Buffer buffer = output.getBuffer();
                    return buffer;
                }
            }
            if ("application/protobuf".equals(contentType)) {
                ProtoMapper protoMapper = this.scopedProtobufSchemaManager.getOrCreateProtoMapper(this.openAPI, this.operationMeta.getSchemaId(), BodyProcessorCreator.REQUEST_BODY_NAME, ((MediaType)this.requestBody.getContent().get((Object)"application/protobuf")).getSchema());
                RootSerializer serializer = protoMapper.getSerializerSchemaManager().createRootSerializer(protoMapper.getProto().getMessage(BodyProcessorCreator.REQUEST_BODY_NAME), Object.class);
                HashMap<String, Object> bodyArg = new HashMap<String, Object>(1);
                bodyArg.put("value", arg);
                return new BufferImpl().appendBytes(serializer.serialize(bodyArg));
            }
            try (BufferOutputStream output = new BufferOutputStream();){
                if (arg instanceof String) {
                    output.write(((String)arg).getBytes(StandardCharsets.UTF_8));
                } else {
                    RestObjectMapperFactory.getConsumerWriterMapper().writeValue((OutputStream)output, arg);
                }
                Buffer buffer = output.getBuffer();
                return buffer;
            }
        }

        @Override
        public String getParameterPath() {
            return "";
        }

        @Override
        public String getProcessorType() {
            return BodyProcessorCreator.PARAM_TYPE;
        }
    }
}

