/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.DynamicPropertiesSource;
import org.apache.servicecomb.config.YAMLUtil;
import org.apache.servicecomb.config.file.MicroserviceConfigLoader;
import org.apache.servicecomb.foundation.bootstrap.BootStrapService;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class ConfigEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public static final String MICROSERVICE_PROPERTY_SOURCE_NAME = "microservice.yaml";
    public static final String MAPPING_PROPERTY_SOURCE_NAME = "mapping.yaml";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        LegacyPropertyFactory.setEnvironment((Environment)environment);
        ConfigEnvironmentPostProcessor.addMicroserviceDefinitions((Environment)environment);
        this.startupBootStrapService((Environment)environment);
        this.addDynamicConfigurationToSpring((Environment)environment);
    }

    public static void addMicroserviceDefinitions(Environment environment) {
        ConfigEnvironmentPostProcessor.addMicroserviceYAMLToSpring(environment);
        ConfigEnvironmentPostProcessor.addMappingToSpring(environment);
    }

    private void startupBootStrapService(Environment environment) {
        for (BootStrapService bootStrapService : SPIServiceUtils.getSortedService(BootStrapService.class)) {
            bootStrapService.startup(environment);
        }
    }

    private static void addMicroserviceYAMLToSpring(final Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return;
        }
        MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
        if (propertySources.contains(MICROSERVICE_PROPERTY_SOURCE_NAME)) {
            return;
        }
        propertySources.addLast((PropertySource)new EnumerablePropertySource<MicroserviceConfigLoader>(MICROSERVICE_PROPERTY_SOURCE_NAME){
            private final Map<String, Object> values;
            private final String[] propertyNames;
            {
                super(name);
                this.values = new HashMap<String, Object>();
                MicroserviceConfigLoader loader = new MicroserviceConfigLoader();
                loader.loadAndSort();
                loader.getConfigModels().forEach(configModel -> this.values.putAll(YAMLUtil.retrieveItems("", configModel.getConfig())));
                this.propertyNames = this.values.keySet().toArray(new String[0]);
            }

            public String[] getPropertyNames() {
                return this.propertyNames;
            }

            public Object getProperty(String name) {
                List value = this.values.get(name);
                if (value instanceof List) {
                    value = ((List)value).stream().filter(item -> item instanceof String).map(item -> environment.resolvePlaceholders((String)item)).collect(Collectors.toList());
                }
                return value;
            }
        });
    }

    private static void addMappingToSpring(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return;
        }
        MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
        if (propertySources.contains(MAPPING_PROPERTY_SOURCE_NAME)) {
            return;
        }
        Map<String, Object> mappings = ConfigMapping.getConvertedMap(environment);
        propertySources.addFirst((PropertySource)new MapPropertySource(MAPPING_PROPERTY_SOURCE_NAME, mappings));
    }

    private void addDynamicConfigurationToSpring(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return;
        }
        for (DynamicPropertiesSource dynamicPropertiesSource : SPIServiceUtils.getOrLoadSortedService(DynamicPropertiesSource.class)) {
            ((ConfigurableEnvironment)environment).getPropertySources().addFirst((PropertySource)dynamicPropertiesSource.create(environment));
        }
    }
}

