/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Tracing;
import brave.context.slf4j.MDCScopeDecorator;
import brave.handler.SpanHandler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalCurrentTraceContext;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.DynamicProperties;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.brave.AsyncZipkinSpanHandler;
import zipkin2.reporter.okhttp3.OkHttpSender;

@Configuration
@ConditionalOnProperty(value={"servicecomb.tracing.zipkin.enabled"}, havingValue="true")
public class TracingConfiguration {
    public static final String TRACING_PREFIX = "servicecomb.tracing.zipkin";
    public static final String TRACING_WORK_WITH_THIRDPARTY = "servicecomb.tracing.workWithThirdParty";
    public static final String TRACING_ENABLED = "servicecomb.tracing.zipkin.enabled";
    private String apiVersion = "v2";

    @Bean
    Sender sender(DynamicProperties dynamicProperties) {
        this.apiVersion = dynamicProperties.getStringProperty("servicecomb.tracing.collector.apiVersion", "v2").toLowerCase();
        if (this.apiVersion.compareTo("v1") != 0) {
            this.apiVersion = "v2";
        }
        String path = MessageFormat.format("/api/{0}/spans", this.apiVersion);
        return OkHttpSender.create((String)dynamicProperties.getStringProperty("servicecomb.tracing.collector.address", "http://127.0.0.1:9411").trim().replaceAll("/+$", "").concat(path));
    }

    @Bean
    Reporter<Span> zipkinReporter(Sender sender) {
        if (this.apiVersion.compareTo("v1") == 0) {
            return AsyncReporter.builder((Sender)sender).build((BytesEncoder)SpanBytesEncoder.JSON_V1);
        }
        return AsyncReporter.builder((Sender)sender).build();
    }

    @Bean
    Tracing tracing(Sender sender, DynamicProperties dynamicProperties, CurrentTraceContext currentTraceContext, Environment environment) {
        return Tracing.newBuilder().localServiceName(BootStrapProperties.readServiceName((Environment)environment)).currentTraceContext(currentTraceContext).addSpanHandler((SpanHandler)AsyncZipkinSpanHandler.create((Sender)sender)).build();
    }

    @Bean
    CurrentTraceContext currentTraceContext() {
        return ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator(MDCScopeDecorator.newBuilder().build()).build();
    }

    @Bean
    HttpTracing httpTracing(Tracing tracing) {
        return HttpTracing.create((Tracing)tracing);
    }

    @Bean
    ZipkinTracingFilter zipkinTracingFilter() {
        return new ZipkinTracingFilter();
    }

    public static String createRequestPath(Invocation invocation) throws Exception {
        URIEndpointObject address = (URIEndpointObject)invocation.getEndpoint().getAddress();
        String urlPrefix = address.getFirst("urlPrefix");
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        String path = (String)invocation.getHandlerContext().get("rest-client-request-path");
        if (path == null) {
            path = swaggerRestOperation.getPathBuilder().createRequestPath(invocation.getSwaggerArguments());
        }
        if (StringUtils.isEmpty((CharSequence)urlPrefix) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }
}

