/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.edge.core.URLMappedConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class URLMappedConfigurationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(URLMappedConfigurationLoader.class);
    private static final String KEY_MAPPING_PATH = ".path";
    private static final String KEY_MAPPING_SERVICE_NAME = "%s.%s.microserviceName";
    private static final String KEY_MAPPING_VERSION_RULE = "%s.%s.versionRule";
    private static final String KEY_MAPPING_PREFIX_SEGMENT_COUNT = "%s.%s.prefixSegmentCount";

    public static Map<String, URLMappedConfigurationItem> loadConfigurations(Environment environment, String configPrefix) {
        HashMap<String, URLMappedConfigurationItem> configurations = new HashMap<String, URLMappedConfigurationItem>();
        Set configsItems = ConfigUtil.propertiesWithPrefix((Environment)((ConfigurableEnvironment)environment), (String)configPrefix);
        for (String pathKey : configsItems) {
            if (!pathKey.endsWith(KEY_MAPPING_PATH)) continue;
            URLMappedConfigurationItem configurationItem = new URLMappedConfigurationItem();
            String pattern = environment.getProperty(pathKey);
            if (StringUtils.isEmpty((CharSequence)pattern)) continue;
            configurationItem.setPattern(Pattern.compile(pattern));
            configurationItem.setStringPattern(pattern);
            String pathKeyItem = pathKey.substring(configPrefix.length() + 1, pathKey.length() - KEY_MAPPING_PATH.length());
            configurationItem.setMicroserviceName(environment.getProperty(String.format(KEY_MAPPING_SERVICE_NAME, configPrefix, pathKeyItem)));
            if (StringUtils.isEmpty((CharSequence)configurationItem.getMicroserviceName())) continue;
            configurationItem.setPrefixSegmentCount((Integer)environment.getProperty(String.format(KEY_MAPPING_PREFIX_SEGMENT_COUNT, configPrefix, pathKeyItem), Integer.TYPE, (Object)0));
            configurationItem.setVersionRule(environment.getProperty(String.format(KEY_MAPPING_VERSION_RULE, configPrefix, pathKeyItem), "0.0.0+"));
            configurations.put(pathKeyItem, configurationItem);
        }
        URLMappedConfigurationLoader.logConfigurations(configurations);
        return configurations;
    }

    private static void logConfigurations(Map<String, URLMappedConfigurationItem> configurations) {
        configurations.forEach((key, item) -> LOG.info("config item: key=" + key + ";pattern=" + item.getStringPattern() + ";service=" + item.getMicroserviceName() + ";versionRule=" + item.getVersionRule()));
    }
}

