/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.rest.RestProducerInvocationFlow;
import org.apache.servicecomb.core.invocation.InvocationCreator;
import org.apache.servicecomb.edge.core.AbstractEdgeDispatcher;
import org.apache.servicecomb.edge.core.EdgeInvocationCreator;
import org.apache.servicecomb.edge.core.Utils;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxServerResponseToHttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class DefaultEdgeDispatcher
extends AbstractEdgeDispatcher {
    private static final String KEY_ENABLED = "servicecomb.http.dispatcher.edge.default.enabled";
    private static final String KEY_ORDER = "servicecomb.http.dispatcher.edge.default.order";
    private static final String KEY_PREFIX = "servicecomb.http.dispatcher.edge.default.prefix";
    private static final String KEY_PREFIX_SEGMENT_COUNT = "servicecomb.http.dispatcher.edge.default.prefixSegmentCount";
    public static final String MICROSERVICE_NAME = "param0";
    private int prefixSegmentCount;
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return LegacyPropertyFactory.getIntProperty((String)KEY_ORDER, (int)20000);
    }

    public boolean enabled() {
        return (Boolean)this.environment.getProperty(KEY_ENABLED, Boolean.TYPE, (Object)false);
    }

    public void init(Router router) {
        String prefix = this.environment.getProperty(KEY_PREFIX, "api");
        this.prefixSegmentCount = (Integer)this.environment.getProperty(KEY_PREFIX_SEGMENT_COUNT, Integer.TYPE, (Object)1);
        String regex = this.generateRouteRegex(prefix, false);
        router.routeWithRegex(regex).handler((Handler)this.createBodyHandler());
        router.routeWithRegex(regex).failureHandler(this::onFailure).handler(this::onRequest);
    }

    @VisibleForTesting
    String generateRouteRegex(String prefix, boolean withVersion) {
        String version = withVersion ? "/([^\\\\/]+)" : "";
        return String.format("/%s/([^\\\\/]+)%s/(.*)", prefix, version);
    }

    protected void onRequest(RoutingContext context) {
        String microserviceName = this.extractMicroserviceName(context);
        String path = Utils.findActualPath(context.request().path(), this.prefixSegmentCount);
        this.requestByFilter(context, microserviceName, path);
    }

    private @Nullable String extractMicroserviceName(RoutingContext context) {
        return context.pathParam(MICROSERVICE_NAME);
    }

    protected void requestByFilter(RoutingContext context, String microserviceName, String path) {
        VertxServerRequestToHttpServletRequest requestEx = new VertxServerRequestToHttpServletRequest(context);
        VertxServerResponseToHttpServletResponse responseEx = new VertxServerResponseToHttpServletResponse(context.response());
        EdgeInvocationCreator creator = new EdgeInvocationCreator(context, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx, microserviceName, path);
        new RestProducerInvocationFlow((InvocationCreator)creator, (HttpServletRequestEx)requestEx, (HttpServletResponseEx)responseEx).run();
    }
}

