/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import jakarta.servlet.http.Part;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.swagger.converter.Converter;
import org.apache.servicecomb.swagger.converter.property.ArrayPropertyConverter;
import org.apache.servicecomb.swagger.converter.property.MapPropertyConverter;
import org.apache.servicecomb.swagger.converter.property.ObjectPropertyConverter;

public final class ConverterMgr {
    private static final JavaType VOID_JAVA_TYPE = TypeFactory.defaultInstance().constructType(Void.class);
    private static final Map<String, JavaType> TYPE_FORMAT_MAP = new HashMap<String, JavaType>();
    private static final Map<Class<?>, Converter> converterMap = new HashMap();

    private static String genTypeFormatKey(String type, String format) {
        return type + ":" + (format == null ? "" : format);
    }

    private ConverterMgr() {
    }

    private static void initTypeFormatMap() {
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("boolean", ""), TypeFactory.defaultInstance().constructType(Boolean.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("integer", "int32"), TypeFactory.defaultInstance().constructType(Integer.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("integer", "int64"), TypeFactory.defaultInstance().constructType(Long.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("number", "float"), TypeFactory.defaultInstance().constructType(Float.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("number", "double"), TypeFactory.defaultInstance().constructType(Double.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("string", ""), TypeFactory.defaultInstance().constructType(String.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("string", "date"), TypeFactory.defaultInstance().constructType(LocalDate.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("string", "date-time"), TypeFactory.defaultInstance().constructType(LocalDateTime.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("string", "password"), TypeFactory.defaultInstance().constructType(String.class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("string", "byte"), TypeFactory.defaultInstance().constructType(Byte[].class));
        TYPE_FORMAT_MAP.put(ConverterMgr.genTypeFormatKey("string", "binary"), TypeFactory.defaultInstance().constructType(Part.class));
    }

    private static void initConverters() {
        converterMap.put(ArraySchema.class, new ArrayPropertyConverter());
        converterMap.put(MapSchema.class, new MapPropertyConverter());
        converterMap.put(ObjectSchema.class, new ObjectPropertyConverter());
        converterMap.put(Schema.class, new ObjectPropertyConverter());
    }

    public static JavaType findJavaType(String type, String format) {
        String key = ConverterMgr.genTypeFormatKey(type, format);
        return TYPE_FORMAT_MAP.get(key);
    }

    public static JavaType findJavaType(OpenAPI swagger, Schema def) {
        if (def == null) {
            return VOID_JAVA_TYPE;
        }
        JavaType javaType = ConverterMgr.findJavaType(def.getType(), def.getFormat());
        if (javaType != null) {
            return javaType;
        }
        Converter converter = converterMap.get(def.getClass());
        if (converter == null) {
            throw new Error("not support def type: " + def.getClass());
        }
        return converter.convert(swagger, def);
    }

    static {
        ConverterMgr.initTypeFormatMap();
        ConverterMgr.initConverters();
    }
}

