/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.sc;

import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.apache.servicecomb.registry.sc.SCConfigurationProperties;
import org.apache.servicecomb.service.center.client.ServiceCenterAddressManager;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterRawClient;
import org.apache.servicecomb.service.center.client.ServiceCenterWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SCClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCClientUtils.class);

    public static ServiceCenterAddressManager createAddressManager(SCConfigurationProperties discoveryProperties) {
        List addresses = ConfigUtil.parseArrayValue((String)discoveryProperties.getAddress());
        LOGGER.info("initialize discovery server={}", (Object)addresses);
        return new ServiceCenterAddressManager("default", addresses, EventManager.getEventBus());
    }

    public static ServiceCenterClient serviceCenterClient(SCConfigurationProperties discoveryProperties, Environment environment) {
        ServiceCenterAddressManager addressManager = SCClientUtils.createAddressManager(discoveryProperties);
        HttpConfiguration.SSLProperties sslProperties = SCClientUtils.buildSslProperties(addressManager, environment);
        return new ServiceCenterClient(new ServiceCenterRawClient.Builder().setTenantName("default").setAddressManager(addressManager).setHttpTransport(SCClientUtils.createHttpTransport(environment, sslProperties)).build());
    }

    private static HttpTransport createHttpTransport(Environment environment, HttpConfiguration.SSLProperties sslProperties) {
        List authHeaderProviders = SPIServiceUtils.getOrLoadSortedService(AuthHeaderProvider.class);
        if (SCClientUtils.isProxyEnable(environment).booleanValue()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(HttpTransportFactory.defaultRequestConfig().build());
            HttpHost proxy = new HttpHost(SCClientUtils.getProxyHost(environment), SCClientUtils.getProxyPort(environment), "http");
            httpClientBuilder.setProxy(proxy);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(SCClientUtils.getProxyUsername(environment), SCClientUtils.getProxyPasswd(environment)));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)sslProperties, (RequestAuthHeaderProvider)SCClientUtils.getRequestAuthHeaderProvider(authHeaderProviders), (HttpClientBuilder)httpClientBuilder);
        }
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)sslProperties, (RequestAuthHeaderProvider)SCClientUtils.getRequestAuthHeaderProvider(authHeaderProviders), (RequestConfig)HttpTransportFactory.defaultRequestConfig().build());
    }

    public static Boolean isProxyEnable(Environment environment) {
        return (Boolean)environment.getProperty("servicecomb.proxy.enable", Boolean.TYPE, (Object)false);
    }

    public static String getProxyHost(Environment environment) {
        return environment.getProperty("servicecomb.proxy.host", "127.0.0.1");
    }

    public static int getProxyPort(Environment environment) {
        return (Integer)environment.getProperty("servicecomb.proxy.port", Integer.TYPE, (Object)8080);
    }

    public static String getProxyUsername(Environment environment) {
        return environment.getProperty("servicecomb.proxy.username");
    }

    public static String getProxyPasswd(Environment environment) {
        return environment.getProperty("servicecomb.proxy.passwd");
    }

    private static HttpConfiguration.SSLProperties buildSslProperties(ServiceCenterAddressManager addressManager, Environment environment) {
        SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)"sc.consumer", (Environment)environment);
        SSLOption sslOption = factory == null ? SSLOption.build((String)"sc.consumer", (Environment)environment) : factory.createSSLOption();
        SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
        HttpConfiguration.SSLProperties sslProperties = new HttpConfiguration.SSLProperties();
        sslProperties.setSslCustom(sslCustom);
        sslProperties.setSslOption(sslOption);
        sslProperties.setEnabled(addressManager.sslEnabled());
        return sslProperties;
    }

    public static ServiceCenterWatch serviceCenterWatch(SCConfigurationProperties discoveryProperties, List<AuthHeaderProvider> authHeaderProviders, Environment environment) {
        ServiceCenterAddressManager addressManager = SCClientUtils.createAddressManager(discoveryProperties);
        HttpConfiguration.SSLProperties sslProperties = SCClientUtils.buildSslProperties(addressManager, environment);
        return new ServiceCenterWatch(addressManager, sslProperties, SCClientUtils.getRequestAuthHeaderProvider(authHeaderProviders), "default", new HashMap(), EventManager.getEventBus());
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }
}

