/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.server;

import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import java.net.InetSocketAddress;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.ExceptionUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.apache.servicecomb.foundation.vertx.AsyncResultCallback;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultTcpServerMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultServerEndpointMetric;
import org.apache.servicecomb.foundation.vertx.server.TcpServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class TcpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpServer.class);
    private final URIEndpointObject endpointObject;

    public TcpServer(URIEndpointObject endpointObject) {
        this.endpointObject = endpointObject;
    }

    public void init(Vertx vertx, String sslKey, AsyncResultCallback<InetSocketAddress> callback) {
        NetServer netServer;
        if (this.endpointObject.isSslEnabled()) {
            SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)sslKey, (Environment)LegacyPropertyFactory.getEnvironment());
            SSLOption sslOption = factory == null ? SSLOption.build((String)sslKey, (Environment)LegacyPropertyFactory.getEnvironment()) : factory.createSSLOption();
            SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
            NetServerOptions serverOptions = new NetServerOptions();
            VertxTLSBuilder.buildNetServerOptions(sslOption, sslCustom, serverOptions);
            netServer = vertx.createNetServer(serverOptions);
        } else {
            netServer = vertx.createNetServer();
        }
        netServer.connectHandler(netSocket -> {
            int connectionLimit;
            DefaultTcpServerMetrics serverMetrics = (DefaultTcpServerMetrics)((NetSocketImpl)netSocket).metrics();
            DefaultServerEndpointMetric endpointMetric = serverMetrics.getEndpointMetric();
            long connectedCount = endpointMetric.getCurrentConnectionCount();
            if (connectedCount > (long)(connectionLimit = this.getConnectionLimit())) {
                netSocket.close();
                endpointMetric.onRejectByConnectionLimit();
                return;
            }
            TcpServerConnection connection = this.createTcpServerConnection();
            connection.init((NetSocket)netSocket);
        });
        netServer.exceptionHandler(e -> LOGGER.error("Unexpected error in server.{}", (Object)ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)e)));
        InetSocketAddress socketAddress = this.endpointObject.getSocketAddress();
        netServer.listen(socketAddress.getPort(), socketAddress.getHostString(), ar -> {
            if (ar.succeeded()) {
                callback.success(socketAddress);
                return;
            }
            String msg = String.format("listen failed, address=%s", socketAddress);
            callback.fail(new Exception(msg, ar.cause()));
        });
    }

    protected int getConnectionLimit() {
        return Integer.MAX_VALUE;
    }

    protected TcpServerConnection createTcpServerConnection() {
        return new TcpServerConnection();
    }
}

