/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParameters;

public class RequestHeaderAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String RESULT_NOT_FOUND = "-";
    private final String varName;

    public RequestHeaderAccessItem(String varName) {
        this.varName = varName;
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        MultiMap headers = accessLogEvent.getRoutingContext().request().headers();
        if (null == headers || StringUtils.isEmpty((CharSequence)headers.get(this.varName))) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        builder.append(headers.get(this.varName));
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent clientLogEvent, StringBuilder builder) {
        RestClientRequestParameters restRequestImpl = (RestClientRequestParameters)clientLogEvent.getInvocation().getHandlerContext().get("servicecomb-invocation-hanlder-requestclient");
        if (null == restRequestImpl || null == restRequestImpl.getHttpClientRequest() || null == restRequestImpl.getHttpClientRequest().headers() || StringUtils.isEmpty((CharSequence)restRequestImpl.getHttpClientRequest().headers().get(this.varName))) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        builder.append(restRequestImpl.getHttpClientRequest().headers().get(this.varName));
    }

    public String getVarName() {
        return this.varName;
    }
}

