/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import java.util.ArrayList;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public abstract class AbstractDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDiscoveryFilter.class);
    protected Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        String childName;
        DiscoveryTreeNode node;
        if (!parent.childrenInited()) {
            DiscoveryTreeNode discoveryTreeNode = parent;
            synchronized (discoveryTreeNode) {
                if (!parent.childrenInited()) {
                    this.init(context, parent);
                    parent.childrenInited(true);
                }
            }
        }
        if ((node = parent.child(childName = this.findChildName(context, parent))) == null) {
            LOGGER.warn("discovery filter {}/{} return null.", (Object)this.getClass().getSimpleName(), (Object)childName);
            return (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, "empty").data(new ArrayList());
        }
        return node;
    }

    protected abstract void init(DiscoveryContext var1, DiscoveryTreeNode var2);

    protected abstract String findChildName(DiscoveryContext var1, DiscoveryTreeNode var2);
}

