/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.consumer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.LambdaMetafactoryUtils;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;
import org.apache.servicecomb.swagger.invocation.arguments.AbstractArgumentsMapperCreator;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ArgumentsMapperCommon;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ArgumentsMapperDirectReuse;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentSame;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentToBodyField;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerBeanParamMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerArgumentsMapperCreator
extends AbstractArgumentsMapperCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerArgumentsMapperCreator.class);
    private int unknownConsumerParams = 0;

    public ConsumerArgumentsMapperCreator(SerializationConfig serializationConfig, Map<Class<?>, ContextArgumentMapperFactory> contextFactorys, Class<?> consumerClass, Method consumerMethod, SwaggerOperation swaggerOperation) {
        super(serializationConfig, contextFactorys, consumerClass, consumerMethod, swaggerOperation);
    }

    private boolean isAllSameMapper() {
        for (ArgumentMapper mapper : this.mappers) {
            if (mapper instanceof ConsumerArgumentSame && ((ConsumerArgumentSame)mapper).isSameMapping()) continue;
            return false;
        }
        return true;
    }

    public ArgumentsMapper createArgumentsMapper() {
        this.doCreateArgumentsMapper();
        if (this.unknownConsumerParams == 0 && this.mappers.size() == this.swaggerOperation.parameterCount() && this.isAllSameMapper()) {
            return new ArgumentsMapperDirectReuse();
        }
        return new ArgumentsMapperCommon(this.mappers);
    }

    @Override
    protected void processUnknownParameter(int providerParamIdx, java.lang.reflect.Parameter providerParameter, String parameterName) {
        LOGGER.warn("Consumer parameter({}) is not exist in contract, method={}:{}.", new Object[]{parameterName, this.providerMethod.getDeclaringClass().getName(), this.providerMethod.getName()});
        ++this.unknownConsumerParams;
    }

    @Override
    protected void processPendingSwaggerParameter(Parameter parameter) {
    }

    @Override
    protected void processPendingBodyParameter(RequestBody parameter) {
    }

    @Override
    protected ArgumentMapper createKnownParameterMapper(int providerParamIdx, String invocationArgumentName) {
        return new ConsumerArgumentSame(this.providerMethod.getParameters()[providerParamIdx].getName(), invocationArgumentName);
    }

    @Override
    protected ArgumentMapper createSwaggerBodyFieldMapper(int consumerParamIdx, String parameterName) {
        return new ConsumerArgumentToBodyField(this.providerMethod.getParameters()[consumerParamIdx].getName(), (String)this.bodyParameter.getExtensions().get("x-name"), parameterName);
    }

    @Override
    protected boolean processBeanParameter(int consumerParamIdx, java.lang.reflect.Parameter consumerParameter) {
        JavaType consumerType = TypeFactory.defaultInstance().constructType(consumerParameter.getParameterizedType());
        if (!SwaggerUtils.isBean((Type)consumerType)) {
            return false;
        }
        boolean result = false;
        ConsumerBeanParamMapper mapper = new ConsumerBeanParamMapper(this.providerMethod.getParameters()[consumerParamIdx].getName());
        for (BeanPropertyDefinition propertyDefinition : this.serializationConfig.introspect(consumerType).findProperties()) {
            String parameterName = SwaggerGeneratorUtils.collectParameterName((Method)this.providerMethod, (BeanPropertyDefinition)propertyDefinition);
            if (!this.parameterNameExistsInSwagger(parameterName)) continue;
            mapper.addField(parameterName, (Getter<Object, Object>)LambdaMetafactoryUtils.createObjectGetter((BeanPropertyDefinition)propertyDefinition));
            this.processedSwaggerParameters.add(parameterName);
            result = true;
        }
        this.mappers.add(mapper);
        return result;
    }
}

