/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.engine;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.engine.SwaggerProducer;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperations;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapperCreator;
import org.apache.servicecomb.swagger.invocation.arguments.consumer.ConsumerContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapperCreator;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.response.ResponseMapperFactorys;
import org.apache.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapper;
import org.apache.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapperFactory;
import org.apache.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;
import org.apache.servicecomb.swagger.invocation.response.producer.ProducerResponseMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerEnvironment.class);

    public SwaggerConsumer createConsumer(Class<?> consumerIntf, OpenAPI swagger) {
        swagger = this.checkAndGenerateSwagger(consumerIntf, swagger);
        Map<Class<?>, ContextArgumentMapperFactory> contextFactorys = SPIServiceUtils.getOrLoadSortedService(ConsumerContextArgumentMapperFactory.class).stream().collect(Collectors.toMap(ContextArgumentMapperFactory::getContextClass, Function.identity()));
        ResponseMapperFactorys consumerResponseMapperFactorys = new ResponseMapperFactorys(ConsumerResponseMapperFactory.class);
        SwaggerOperations swaggerOperations = new SwaggerOperations(swagger);
        SwaggerConsumer consumer = new SwaggerConsumer();
        consumer.setConsumerIntf(consumerIntf);
        for (Method consumerMethod : MethodUtils.findSwaggerMethods(consumerIntf)) {
            String operationId = this.findOperationId(consumerMethod);
            SwaggerOperation swaggerOperation = swaggerOperations.findOperation(operationId);
            if (swaggerOperation == null) {
                LOGGER.warn("consumer method {}:{} not exist in contract.", (Object)consumerIntf.getName(), (Object)consumerMethod.getName());
                continue;
            }
            ConsumerArgumentsMapperCreator creator = new ConsumerArgumentsMapperCreator(Json.mapper().getSerializationConfig(), contextFactorys, consumerIntf, consumerMethod, swaggerOperation);
            ArgumentsMapper argsMapper = creator.createArgumentsMapper();
            ConsumerResponseMapper responseMapper = (ConsumerResponseMapper)consumerResponseMapperFactorys.createResponseMapper(consumerMethod.getGenericReturnType());
            SwaggerConsumerOperation op = new SwaggerConsumerOperation();
            op.setConsumerClass(consumerIntf);
            op.setConsumerMethod(consumerMethod);
            op.setSwaggerOperation(swaggerOperation);
            op.setArgumentsMapper(argsMapper);
            op.setResponseMapper(responseMapper);
            consumer.addOperation(op);
        }
        return consumer;
    }

    protected String findOperationId(Method consumerMethod) {
        return MethodUtils.findSwaggerMethodName((Method)consumerMethod);
    }

    public SwaggerProducer createProducer(Object producerInstance) {
        return this.createProducer(producerInstance, null);
    }

    public SwaggerProducer createProducer(Object producerInstance, Class<?> schemaInterface) {
        Class<?> producerCls = this.targetSwaggerClass(producerInstance, schemaInterface);
        OpenAPI swagger = SwaggerGenerator.generate(producerCls);
        Map<Class<?>, ContextArgumentMapperFactory> contextFactories = SPIServiceUtils.getOrLoadSortedService(ProducerContextArgumentMapperFactory.class).stream().collect(Collectors.toMap(ContextArgumentMapperFactory::getContextClass, Function.identity()));
        ResponseMapperFactorys producerResponseMapperFactorys = new ResponseMapperFactorys(ProducerResponseMapperFactory.class);
        SwaggerOperations swaggerOperations = new SwaggerOperations(swagger);
        Map visibleProducerMethods = MethodUtils.findSwaggerMethodsMapOfOperationId(producerCls);
        SwaggerProducer producer = new SwaggerProducer();
        producer.setSwagger(swagger);
        producer.setProducerCls(producerCls);
        producer.setProducerInstance(producerInstance);
        for (SwaggerOperation swaggerOperation : swaggerOperations.getOperations().values()) {
            String operationId = swaggerOperation.getOperationId();
            Method producerMethod = visibleProducerMethods.getOrDefault(operationId, null);
            if (producerMethod == null) {
                String msg = String.format("operationId %s not exist in producer %s.", operationId, producerInstance.getClass().getName());
                throw new IllegalStateException(msg);
            }
            ProducerArgumentsMapperCreator creator = new ProducerArgumentsMapperCreator(Json.mapper().getSerializationConfig(), contextFactories, producerCls, producerMethod, swaggerOperation);
            ProducerArgumentsMapper argsMapper = creator.createArgumentsMapper();
            ProducerResponseMapper responseMapper = (ProducerResponseMapper)producerResponseMapperFactorys.createResponseMapper(producerMethod.getGenericReturnType());
            SwaggerProducerOperation op = new SwaggerProducerOperation();
            op.setProducerClass(producerCls);
            op.setProducerInstance(producerInstance);
            op.setProducerMethod(producerMethod);
            op.setSwaggerOperation(swaggerOperation);
            op.setSwaggerParameterTypes(creator.getSwaggerParameterTypes());
            op.setArgumentsMapper(argsMapper);
            op.setResponseMapper(responseMapper);
            producer.addOperation(op);
        }
        return producer;
    }

    private OpenAPI checkAndGenerateSwagger(Class<?> swaggerClass, OpenAPI swagger) {
        if (swagger == null) {
            swagger = SwaggerGenerator.generate(swaggerClass);
        }
        return swagger;
    }

    private Class<?> targetSwaggerClass(Object producerInstance, Class<?> schemaInterface) {
        if (schemaInterface != null && !Object.class.equals(schemaInterface)) {
            return schemaInterface;
        }
        return BeanUtils.getImplClassFromBean((Object)producerInstance);
    }
}

