/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.tracing;

import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.tracing.ScbMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class TraceIdLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"scb-trace");
    private static final Marker MARKER = new ScbMarker();
    public static final String KEY_TRACE_ID = "SERVICECOMB_TRACE_ID";
    private final Invocation invocation;

    public TraceIdLogger(Invocation invocation) {
        this.invocation = invocation;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public static String constructSource(String source) {
        return "[" + source + "(" + Thread.currentThread().getStackTrace()[2].getLineNumber() + ")]";
    }

    public final String getName() {
        return this.invocation.getTraceId();
    }

    public void error(String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        LOGGER.error(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }

    public void warn(String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        LOGGER.warn(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }

    public void info(String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        LOGGER.info(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }

    public void debug(String format, Object ... arguments) {
        MDC.put((String)KEY_TRACE_ID, (String)this.getName());
        LOGGER.debug(MARKER, format, arguments);
        MDC.remove((String)KEY_TRACE_ID);
    }
}

