/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import org.apache.servicecomb.core.event.InvocationBusinessFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodStartEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.core.event.InvocationStartSendRequestEvent;
import org.apache.servicecomb.core.event.InvocationTimeoutCheckEvent;
import org.apache.servicecomb.core.invocation.InvocationTimeoutStrategy;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class InvocationTimeoutBootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvocationTimeoutBootListener.class);
    public static final String PREFIX = "servicecomb.invocation.timeout.check";
    public static final String STRATEGY = "servicecomb.invocation.timeout.check.strategy";
    public static final String ENABLED = "servicecomb.invocation.timeout.check.enabled";
    private final InvocationTimeoutStrategy strategy;

    public InvocationTimeoutBootListener(EventBus eventBus, List<InvocationTimeoutStrategy> strategies, Environment environment) {
        if (!((Boolean)environment.getProperty(ENABLED, Boolean.TYPE, (Object)false)).booleanValue()) {
            this.strategy = null;
            return;
        }
        String strategyName = environment.getProperty(STRATEGY, "passing-time");
        this.strategy = strategies.stream().filter(invocationTimeoutStrategy -> strategyName.equals(invocationTimeoutStrategy.name())).findFirst().orElseThrow(() -> new IllegalStateException("can not find InvocationTimeoutStrategy, name=" + strategyName));
        eventBus.register((Object)this);
    }

    @Subscribe
    @EnableExceptionPropagation
    public void onInvocationTimeoutCheckEvent(InvocationTimeoutCheckEvent event) {
        this.strategy.checkTimeout(event.getInvocation());
    }

    @Subscribe
    public void onInvocationStartEvent(InvocationStartEvent event) {
        this.strategy.start(event.getInvocation());
    }

    @Subscribe
    @EnableExceptionPropagation
    public void onInvocationBusinessMethodStartEvent(InvocationBusinessMethodStartEvent event) {
        this.strategy.startBusinessMethod(event.getInvocation());
    }

    @Subscribe
    @EnableExceptionPropagation
    public void onInvocationBusinessFinishEvent(InvocationBusinessFinishEvent event) {
        this.strategy.finishBusinessMethod(event.getInvocation());
    }

    @Subscribe
    @EnableExceptionPropagation
    public void onInvocationStartSendRequestEvent(InvocationStartSendRequestEvent event) {
        this.strategy.beforeSendRequest(event.getInvocation());
    }
}

