/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.executor.ReactiveExecutor;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class ExecutorManager {
    public static final String KEY_EXECUTORS_PREFIX = "servicecomb.executors.Provider.";
    public static final String KEY_EXECUTORS_DEFAULT = "servicecomb.executors.default";
    public static final String EXECUTOR_GROUP_THREAD_POOL = "servicecomb.executor.groupThreadPool";
    public static final String EXECUTOR_REACTIVE = "servicecomb.executor.reactive";
    private final Map<String, Executor> executors = new ConcurrentHashMapEx();
    static String EXECUTOR_DEFAULT = "servicecomb.executor.groupThreadPool";
    private Environment environment;

    public static void setExecutorDefault(String executorDefault) {
        EXECUTOR_DEFAULT = executorDefault;
    }

    public ExecutorManager() {
        this.registerExecutor(EXECUTOR_REACTIVE, new ReactiveExecutor());
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerExecutor(String id, Executor executor) {
        Executor existing = this.executors.putIfAbsent(id, executor);
        if (existing != null) {
            throw new IllegalStateException(String.format("duplicated executor, id=%s, old executor=%s, new executor=%s", id, existing.getClass().getName(), executor.getClass().getName()));
        }
    }

    public Executor findExecutor(OperationMeta operationMeta) {
        return this.findExecutor(operationMeta, null);
    }

    public Executor findExecutor(OperationMeta operationMeta, Executor defaultOperationExecutor) {
        Executor executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getMicroserviceQualifiedName());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getSchemaQualifiedName());
        if (executor != null) {
            return executor;
        }
        if (defaultOperationExecutor != null) {
            return defaultOperationExecutor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getMicroserviceName() + "." + operationMeta.getSchemaId());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getSchemaId());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getMicroserviceName());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_DEFAULT);
        if (executor != null) {
            return executor;
        }
        return this.findExecutorById(EXECUTOR_DEFAULT);
    }

    protected Executor findByKey(String configKey) {
        String id = this.environment.getProperty(configKey);
        if (id == null) {
            return null;
        }
        return this.findExecutorById(id);
    }

    public Executor findExecutorById(String id) {
        Executor executor = this.executors.get(id);
        if (executor != null) {
            return executor;
        }
        return (Executor)BeanUtils.getBean((String)id);
    }
}

