/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie;

import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.config.DynamicPropertiesSource;
import org.apache.servicecomb.config.common.ConfigConverter;
import org.apache.servicecomb.config.kie.KieConfig;
import org.apache.servicecomb.config.kie.TransportUtils;
import org.apache.servicecomb.config.kie.client.KieClient;
import org.apache.servicecomb.config.kie.client.KieConfigManager;
import org.apache.servicecomb.config.kie.client.KieConfigOperation;
import org.apache.servicecomb.config.kie.client.KieConfigurationChangedEvent;
import org.apache.servicecomb.config.kie.client.model.KieAddressManager;
import org.apache.servicecomb.config.kie.client.model.KieConfiguration;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class KieDynamicPropertiesSource
implements DynamicPropertiesSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieDynamicPropertiesSource.class);
    public static final String SOURCE_NAME = "kie";
    private final Map<String, Object> data = new ConcurrentHashMapEx();
    private KieConfigManager kieConfigManager;
    private ConfigConverter configConverter;

    private void init(Environment environment) {
        KieConfig kieConfig = new KieConfig(environment);
        this.configConverter = new ConfigConverter(kieConfig.getFileSources());
        KieAddressManager kieAddressManager = this.configKieAddressManager(kieConfig);
        RequestConfig.Builder requestBuilder = HttpTransportFactory.defaultRequestConfig();
        if (kieConfig.enableLongPolling() && kieConfig.getPollingWaitTime() >= 0) {
            requestBuilder.setConnectionRequestTimeout(kieConfig.getPollingWaitTime() * 2 * 1000);
            requestBuilder.setSocketTimeout(kieConfig.getPollingWaitTime() * 2 * 1000);
        }
        HttpTransport httpTransport = this.createHttpTransport(kieAddressManager, requestBuilder.build(), kieConfig, environment);
        KieConfiguration kieConfiguration = this.createKieConfiguration(kieConfig, environment);
        KieClient kieClient = new KieClient(kieAddressManager, httpTransport, kieConfiguration);
        EventManager.register((Object)this);
        this.kieConfigManager = new KieConfigManager((KieConfigOperation)kieClient, EventManager.getEventBus(), kieConfiguration, this.configConverter, kieAddressManager);
        this.kieConfigManager.firstPull();
        this.kieConfigManager.startConfigKieManager();
        this.data.putAll(this.configConverter.getCurrentData());
    }

    @Subscribe
    public void onConfigurationChangedEvent(KieConfigurationChangedEvent event) {
        LOGGER.info("Dynamic configuration changed: {}", (Object)event.getChanged());
        this.data.putAll(event.getAdded());
        this.data.putAll(event.getUpdated());
        event.getDeleted().forEach((k, v) -> this.data.remove(k));
        EventManager.post((Object)ConfigurationChangedEvent.createIncremental((Map)event.getAdded(), (Map)event.getUpdated(), (Map)event.getDeleted()));
    }

    private KieConfiguration createKieConfiguration(KieConfig kieConfig, Environment environment) {
        return new KieConfiguration().setAppName(BootStrapProperties.readApplication((Environment)environment)).setServiceName(BootStrapProperties.readServiceName((Environment)environment)).setEnvironment(BootStrapProperties.readServiceEnvironment((Environment)environment)).setVersion(BootStrapProperties.readServiceVersion((Environment)environment)).setFirstPullRequired(kieConfig.firstPullRequired()).setCustomLabel(kieConfig.getCustomLabel()).setCustomLabelValue(kieConfig.getCustomLabelValue()).setEnableAppConfig(kieConfig.enableAppConfig()).setEnableCustomConfig(kieConfig.enableCustomConfig()).setEnableLongPolling(kieConfig.enableLongPolling()).setEnableServiceConfig(kieConfig.enableServiceConfig()).setEnableVersionConfig(kieConfig.enableVersionConfig()).setPollingWaitInSeconds(kieConfig.getPollingWaitTime()).setProject(kieConfig.getDomainName()).setRefreshIntervalInMillis(kieConfig.getRefreshInterval());
    }

    private HttpTransport createHttpTransport(KieAddressManager kieAddressManager, RequestConfig requestConfig, KieConfig kieConfig, Environment environment) {
        List authHeaderProviders = SPIServiceUtils.getOrLoadSortedService(AuthHeaderProvider.class);
        if (kieConfig.isProxyEnable().booleanValue()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
            HttpHost proxy = new HttpHost(kieConfig.getProxyHost(), kieConfig.getProxyPort(), "http");
            httpClientBuilder.setProxy(proxy);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(kieConfig.getProxyUsername(), kieConfig.getProxyPasswd()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(kieAddressManager.sslEnabled(), environment, "kie.consumer"), (RequestAuthHeaderProvider)KieDynamicPropertiesSource.getRequestAuthHeaderProvider(authHeaderProviders), (HttpClientBuilder)httpClientBuilder);
        }
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(kieAddressManager.sslEnabled(), environment, "kie.consumer"), (RequestAuthHeaderProvider)KieDynamicPropertiesSource.getRequestAuthHeaderProvider(authHeaderProviders), (RequestConfig)requestConfig);
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }

    private KieAddressManager configKieAddressManager(KieConfig kieConfig) {
        return new KieAddressManager(Arrays.asList(kieConfig.getServerUri().split(",")), EventManager.getEventBus());
    }

    public MapPropertySource create(Environment environment) {
        this.init(environment);
        return new MapPropertySource(SOURCE_NAME, this.data);
    }

    public int getOrder() {
        return 0;
    }
}

