/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.lightweight.AbstractLightweightDiscovery;
import org.apache.servicecomb.registry.lightweight.model.Microservice;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstance;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstances;
import org.apache.servicecomb.zeroconfig.Config;
import org.apache.servicecomb.zeroconfig.ZeroConfigDiscoveryInstance;
import org.springframework.beans.factory.annotation.Autowired;

public class ZeroConfigDiscovery
extends AbstractLightweightDiscovery<ZeroConfigDiscoveryInstance> {
    private Config config;

    @Autowired
    public ZeroConfigDiscovery setConfig(Config config) {
        this.config = config;
        return this;
    }

    public String name() {
        return "zero-config-registry";
    }

    public void setInstanceChangedListener(Discovery.InstanceChangedListener<ZeroConfigDiscoveryInstance> instanceChangedListener) {
    }

    public int getOrder() {
        return -8000;
    }

    public boolean enabled() {
        return this.config.isEnabled();
    }

    public void run() {
    }

    public List<ZeroConfigDiscoveryInstance> findServiceInstances(String application, String serviceName) {
        MicroserviceInstances microserviceInstances = this.store.findServiceInstances(application, serviceName, "0");
        if (microserviceInstances.isMicroserviceNotExist() || microserviceInstances.getInstancesResponse() == null) {
            return Collections.emptyList();
        }
        ArrayList<ZeroConfigDiscoveryInstance> result = new ArrayList<ZeroConfigDiscoveryInstance>();
        for (MicroserviceInstance instance : microserviceInstances.getInstancesResponse().getInstances()) {
            result.add(new ZeroConfigDiscoveryInstance((Microservice)this.store.getMicroservice(instance.getServiceId()).get(), instance));
        }
        return result;
    }
}

