/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.CircuitBreakerMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableCircuitBreaker;
import org.apache.servicecomb.governance.handler.ext.AbstractInstanceIsolationExtension;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.CircuitBreakerPolicy;
import org.apache.servicecomb.governance.properties.InstanceIsolationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class InstanceIsolationHandler
extends AbstractGovernanceHandler<CircuitBreaker, CircuitBreakerPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceIsolationHandler.class);
    private final InstanceIsolationProperties instanceIsolationProperties;
    private final AbstractInstanceIsolationExtension isolationExtension;
    private final MeterRegistry meterRegistry;

    public InstanceIsolationHandler(InstanceIsolationProperties instanceIsolationProperties, AbstractInstanceIsolationExtension isolationExtension, ObjectProvider<MeterRegistry> meterRegistry) {
        this.instanceIsolationProperties = instanceIsolationProperties;
        this.isolationExtension = isolationExtension;
        this.meterRegistry = (MeterRegistry)meterRegistry.getIfAvailable();
    }

    @Override
    protected String createKey(GovernanceRequestExtractor requestExtractor, CircuitBreakerPolicy policy) {
        return this.instanceIsolationProperties.getConfigKey() + "." + policy.getName() + "." + requestExtractor.serviceName() + "." + requestExtractor.instanceId();
    }

    @Override
    protected void onConfigurationChanged(String key) {
        if (key.startsWith(this.instanceIsolationProperties.getConfigKey())) {
            for (String processorKey : this.processors.keySet()) {
                Disposable circuitBreaker;
                if (!processorKey.startsWith(key) || (circuitBreaker = (Disposable)this.processors.remove(processorKey)) == null) continue;
                LOGGER.info("remove instance isolation processor {}", (Object)key);
                circuitBreaker.dispose();
            }
        }
    }

    @Override
    public CircuitBreakerPolicy matchPolicy(GovernanceRequestExtractor requestExtractor) {
        if (StringUtils.isEmpty((CharSequence)requestExtractor.serviceName()) || StringUtils.isEmpty((CharSequence)requestExtractor.instanceId())) {
            LOGGER.debug("Isolation is not properly configured, service id or instance id is empty.");
            return null;
        }
        return (CircuitBreakerPolicy)this.matchersManager.match(requestExtractor, this.instanceIsolationProperties.getParsedEntity());
    }

    @Override
    public Disposable<CircuitBreaker> createProcessor(String key, GovernanceRequestExtractor requestExtractor, CircuitBreakerPolicy policy) {
        return this.getCircuitBreaker(key, policy);
    }

    private Disposable<CircuitBreaker> getCircuitBreaker(String key, CircuitBreakerPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(policy.getFailureRateThreshold()).slowCallRateThreshold(policy.getSlowCallRateThreshold()).waitDurationInOpenState(Duration.parse(policy.getWaitDurationInOpenState())).slowCallDurationThreshold(Duration.parse(policy.getSlowCallDurationThreshold())).permittedNumberOfCallsInHalfOpenState(policy.getPermittedNumberOfCallsInHalfOpenState()).minimumNumberOfCalls(policy.getMinimumNumberOfCalls()).slidingWindowType(policy.getSlidingWindowTypeEnum()).slidingWindowSize(Integer.parseInt(policy.getSlidingWindowSize())).recordException(e -> this.isolationExtension.isFailedResult(policy.getRecordFailureStatus(), (Throwable)e)).recordResult(r -> this.isolationExtension.isFailedResult(policy.getRecordFailureStatus(), r)).build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig);
        if (this.meterRegistry != null) {
            TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerMetricNames)CircuitBreakerMetricNames.custom().callsMetricName(this.instanceIsolationProperties.getConfigKey() + ".calls").notPermittedCallsMetricName(this.instanceIsolationProperties.getConfigKey() + ".not.permitted.calls").stateMetricName(this.instanceIsolationProperties.getConfigKey() + ".state").bufferedCallsMetricName(this.instanceIsolationProperties.getConfigKey() + ".buffered.calls").slowCallsMetricName(this.instanceIsolationProperties.getConfigKey() + ".slow.calls").failureRateMetricName(this.instanceIsolationProperties.getConfigKey() + ".failure.rate").slowCallRateMetricName(this.instanceIsolationProperties.getConfigKey() + ".slow.call.rate").build(), (CircuitBreakerRegistry)circuitBreakerRegistry).bindTo(this.meterRegistry);
        }
        return new DisposableCircuitBreaker(key, circuitBreakerRegistry, circuitBreakerRegistry.circuitBreaker(key, circuitBreakerConfig));
    }
}

