/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.registry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;

public class InstancePropertyDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final String MATCHED = "matched";

    public int getOrder() {
        return 400;
    }

    public boolean enabled() {
        return (Boolean)this.environment.getProperty("servicecomb.loadbalance.filter.instanceProperty.enabled", Boolean.TYPE, (Object)true);
    }

    public boolean isGroupingFilter() {
        return false;
    }

    protected void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        ArrayList matchedInstance = new ArrayList();
        Invocation invocation = (Invocation)context.getInputParameters();
        List instances = (List)parent.data();
        Map<String, String> filterOptions = Configuration.INSTANCE.getFlowsplitFilterOptions(invocation.getMicroserviceName());
        instances.forEach(target -> {
            if (this.allowVisit((StatefulDiscoveryInstance)target, filterOptions)) {
                matchedInstance.add(target);
            }
        });
        parent.child(MATCHED, (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, MATCHED).data(matchedInstance));
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        return MATCHED;
    }

    protected boolean allowVisit(StatefulDiscoveryInstance instance, Map<String, String> filterOptions) {
        Map propertiesMap = instance.getProperties();
        for (Map.Entry<String, String> entry : filterOptions.entrySet()) {
            if (entry.getValue().equals(propertiesMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

