/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.localregistry;

import io.swagger.v3.oas.models.OpenAPI;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.provider.LocalOpenAPIRegistry;
import org.apache.servicecomb.localregistry.LocalRegistrationInstance;
import org.apache.servicecomb.localregistry.RegistryBean;
import org.apache.servicecomb.registry.api.AbstractDiscoveryInstance;
import org.apache.servicecomb.registry.api.DataCenterInfo;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class LocalDiscoveryInstance
extends AbstractDiscoveryInstance {
    private static final AtomicLong INSTANCE_ID = new AtomicLong();
    private final RegistryBean registryBean;
    private final LocalRegistrationInstance localRegistrationInstance;
    private final List<String> endpoints;
    private final String instanceId;

    public LocalDiscoveryInstance(LocalOpenAPIRegistry localOpenAPIRegistry, RegistryBean registryBean, List<String> endpoints, LocalRegistrationInstance localRegistrationInstance) {
        this.registryBean = registryBean;
        this.localRegistrationInstance = localRegistrationInstance;
        this.endpoints = endpoints;
        this.instanceId = System.currentTimeMillis() + "-" + ManagementFactory.getRuntimeMXBean().getPid() + "-" + INSTANCE_ID.getAndIncrement();
        registryBean.getSchemaInterfaces().forEach((k, v) -> {
            SwaggerGenerator generator = SwaggerGenerator.create((Class)v);
            OpenAPI openAPI = generator.generate();
            if (openAPI == null) {
                throw new IllegalStateException(String.format("Generate schema for %s/%s/%s faild.", registryBean.getAppId(), registryBean.getServiceName(), k));
            }
            String schemaContent = SwaggerUtils.swaggerToString((OpenAPI)openAPI);
            if (StringUtils.isEmpty((CharSequence)schemaContent)) {
                throw new IllegalStateException(String.format("Generate schema for %s/%s/%s faild.", registryBean.getAppId(), registryBean.getServiceName(), k));
            }
            localOpenAPIRegistry.registerOpenAPI(registryBean.getAppId(), registryBean.getServiceName(), k, openAPI);
        });
    }

    public LocalDiscoveryInstance(LocalRegistrationInstance registrationInstance) {
        this.registryBean = new RegistryBean();
        this.registryBean.setAppId(registrationInstance.getApplication());
        this.registryBean.setServiceName(registrationInstance.getServiceName());
        this.registryBean.setVersion(registrationInstance.getVersion());
        this.localRegistrationInstance = registrationInstance;
        this.endpoints = registrationInstance.getEndpoints();
        this.instanceId = registrationInstance.getInstanceId();
    }

    public MicroserviceInstanceStatus getStatus() {
        return MicroserviceInstanceStatus.UP;
    }

    public String getRegistryName() {
        return "local-registry";
    }

    public String getEnvironment() {
        return this.localRegistrationInstance.getEnvironment();
    }

    public String getApplication() {
        return this.registryBean.getAppId();
    }

    public String getServiceName() {
        return this.registryBean.getServiceName();
    }

    public String getAlias() {
        return null;
    }

    public String getVersion() {
        return this.registryBean.getVersion();
    }

    public DataCenterInfo getDataCenterInfo() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Map<String, String> getProperties() {
        return null;
    }

    public Map<String, String> getSchemas() {
        return Collections.emptyMap();
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

