/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.inject.PlaceholderResolver;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorFeature;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.AbstractOperationGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;

public abstract class AbstractSwaggerGenerator
implements SwaggerGenerator {
    protected SwaggerGeneratorFeature swaggerGeneratorFeature = new SwaggerGeneratorFeature();
    protected SwaggerGeneratorContext swaggerGeneratorContext = new SwaggerGeneratorContext();
    protected Class<?> cls;
    protected OpenAPI openAPI;
    protected Set<String> methodWhiteList = new HashSet<String>();
    protected Map<String, AbstractOperationGenerator> operationGenerators = new LinkedHashMap<String, AbstractOperationGenerator>();
    protected String httpMethod;

    public AbstractSwaggerGenerator(Class<?> cls) {
        this.openAPI = new OpenAPI();
        this.openAPI.components(new Components()).paths(new Paths()).servers(new ArrayList()).info(new Info());
        this.cls = cls;
    }

    @Override
    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    @Override
    public Class<?> getClazz() {
        return this.cls;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod.toUpperCase(Locale.US);
    }

    @Override
    public SwaggerGeneratorFeature getSwaggerGeneratorFeature() {
        return this.swaggerGeneratorFeature;
    }

    @Override
    public SwaggerGeneratorContext getSwaggerGeneratorContext() {
        return this.swaggerGeneratorContext;
    }

    @Override
    public OpenAPI generate() {
        LOGGER.info("generate schema from [{}]", this.cls);
        this.scanClassAnnotation();
        ThreadLocal<SwaggerGeneratorFeature> featureThreadLocal = SwaggerGeneratorFeature.getFeatureThreadLocal();
        featureThreadLocal.set(this.swaggerGeneratorFeature);
        try {
            this.scanMethods();
            this.addOperationsToSwagger();
            this.correctSwagger();
            OpenAPI openAPI = this.openAPI;
            return openAPI;
        }
        finally {
            featureThreadLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanClassAnnotation() {
        ThreadLocal<SwaggerGeneratorFeature> featureThreadLocal = SwaggerGeneratorFeature.getFeatureThreadLocal();
        featureThreadLocal.set(this.swaggerGeneratorFeature);
        try {
            for (Annotation annotation : this.cls.getAnnotations()) {
                ClassAnnotationProcessor<Annotation> processor = SwaggerGeneratorUtils.findClassAnnotationProcessor(annotation.annotationType());
                if (processor == null) continue;
                processor.process(this, annotation);
            }
        }
        finally {
            featureThreadLocal.remove();
        }
    }

    protected void correctSwagger() {
        this.correctBasePath();
        this.correctInfo();
    }

    private void correctBasePath() {
        if (this.openAPI.getServers() == null) {
            this.openAPI.setServers(new ArrayList());
        }
        if (this.openAPI.getServers().size() <= 0) {
            Server server = new Server();
            server.setUrl("/" + this.cls.getSimpleName());
            this.openAPI.getServers().add(server);
        }
    }

    private void correctInfo() {
        Info info = this.openAPI.getInfo();
        if (info == null) {
            info = new Info();
            this.openAPI.setInfo(info);
        }
        if (StringUtils.isEmpty((CharSequence)info.getTitle())) {
            info.setTitle("swagger definition for " + this.cls.getName());
        }
        if (StringUtils.isEmpty((CharSequence)info.getVersion())) {
            info.setVersion("1.0.0");
        }
    }

    @Override
    public void replaceMethodWhiteList(String ... methodNames) {
        this.methodWhiteList.clear();
        if (methodNames == null || methodNames.length == 0) {
            return;
        }
        this.methodWhiteList.addAll(Arrays.asList(methodNames));
    }

    protected boolean isSkipMethod(Method method) {
        if (method.getDeclaringClass().getName().equals(Object.class.getName())) {
            return true;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return true;
        }
        if (method.isBridge()) {
            return true;
        }
        Operation apiOperation = method.getAnnotation(Operation.class);
        if (apiOperation != null && apiOperation.hidden()) {
            return true;
        }
        if (!this.methodWhiteList.isEmpty()) {
            return !this.methodWhiteList.contains(MethodUtils.findSwaggerMethodName(method));
        }
        return false;
    }

    protected void scanMethods() {
        List<Method> methods = MethodUtils.findSwaggerMethods(this.cls);
        for (Method method : methods) {
            if (this.isSkipMethod(method)) continue;
            AbstractOperationGenerator operationGenerator = (AbstractOperationGenerator)this.createOperationGenerator(method);
            operationGenerator.setHttpMethod(this.httpMethod);
            try {
                operationGenerator.generate();
            }
            catch (Throwable e) {
                String msg = String.format("Generate swagger operation failed, method=%s:%s, cause=%s", this.cls.getSimpleName(), method.getName(), e.getMessage());
                throw new IllegalStateException(msg, e);
            }
            if (StringUtils.isEmpty((CharSequence)operationGenerator.httpMethod)) {
                throw new IllegalStateException(String.format("HttpMethod must not both be empty in class and method, method=%s:%s.", this.cls.getName(), method.getName()));
            }
            if (this.operationGenerators.putIfAbsent(operationGenerator.getOperationId(), operationGenerator) == null) continue;
            throw new IllegalStateException(String.format("OperationId must be unique. method=%s:%s.", this.cls.getName(), method.getName()));
        }
    }

    protected void addOperationsToSwagger() {
        for (OperationGenerator operationGenerator : this.operationGenerators.values()) {
            operationGenerator.addOperationToSwagger();
        }
    }

    @Override
    public void setBasePath(String basePath) {
        basePath = new PlaceholderResolver().replaceFirst(basePath);
        Server server = new Server();
        server.setUrl(basePath);
        if (this.openAPI.getServers() == null) {
            this.openAPI.setServers(new ArrayList());
        }
        this.openAPI.getServers().add(server);
    }
}

