/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderProcessorCreator
implements ParamValueProcessorCreator<Parameter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderProcessorCreator.class);
    public static final String PARAMTYPE = "header";

    public HeaderProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(OperationMeta operationMeta, String parameterName, Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new HeaderProcessor((HeaderParameter)parameter, targetType);
    }

    public static class HeaderProcessor
    extends AbstractParamProcessor {
        private final boolean ignoreRequiredCheck = LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.parameter.header.ignoreRequiredCheck", (boolean)false);
        private final boolean repeatedType;

        public HeaderProcessor(HeaderParameter headerParameter, JavaType targetType) {
            super(headerParameter.getName(), targetType, headerParameter.getSchema().getDefault(), headerParameter.getRequired() != null && headerParameter.getRequired() != false);
            this.repeatedType = headerParameter.getSchema() instanceof ArraySchema;
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            if (this.repeatedType) {
                Enumeration headerValues = request.getHeaders(this.paramPath);
                if (headerValues == null) {
                    return null;
                }
                return this.convertValue(Collections.list(headerValues), this.targetType);
            }
            Object value = request.getHeader(this.paramPath);
            if (value == null) {
                value = this.checkRequiredAndDefaultValue();
            }
            return this.convertValue(value, this.targetType);
        }

        private Object checkRequiredAndDefaultValue() {
            if (!this.ignoreRequiredCheck && this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            return this.getDefaultValue();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            if (null == arg) {
                LOGGER.debug("Header arg is null, will not be set into clientRequest. paramPath = [{}]", (Object)this.paramPath);
                return;
            }
            clientRequest.putHeader(this.paramPath, RestObjectMapperFactory.getConsumerWriterMapper().convertToString(arg));
        }

        @Override
        public String getProcessorType() {
            return HeaderProcessorCreator.PARAMTYPE;
        }
    }
}

