/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;

public class InvocationFilterChains {
    private final List<? extends Filter> filters;
    private final Map<String, Map<String, FilterNode>> microserviceChains = new ConcurrentHashMapEx();

    public InvocationFilterChains(List<? extends Filter> filters) {
        this.filters = filters;
    }

    public List<? extends Filter> getFilters() {
        return this.filters;
    }

    public FilterNode findChain(String application, String serviceName) {
        FilterNode filterNode = (FilterNode)this.microserviceChains.computeIfAbsent(application, key -> new ConcurrentHashMapEx()).get(serviceName);
        if (filterNode == null) {
            List<Filter> serviceFilters = this.filters.stream().filter(e -> e.enabledForMicroservice(application, serviceName)).sorted(Comparator.comparingInt(a -> a.getOrder(application, serviceName))).collect(Collectors.toList());
            filterNode = FilterNode.buildChain(serviceFilters);
            this.microserviceChains.get(application).put(serviceName, filterNode);
        }
        return filterNode;
    }
}

