/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.PolledEvent;
import org.apache.servicecomb.foundation.metrics.meter.LatencyDistributionConfig;
import org.apache.servicecomb.foundation.metrics.meter.LatencyScopeConfig;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementTree;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.metrics.core.meter.os.NetMeter;
import org.apache.servicecomb.metrics.core.publish.ClientEndpointsLogPublisher;
import org.apache.servicecomb.metrics.core.publish.PublishModelFactory;
import org.apache.servicecomb.metrics.core.publish.ServerEndpointsLogPublisher;
import org.apache.servicecomb.metrics.core.publish.model.DefaultPublishModel;
import org.apache.servicecomb.metrics.core.publish.model.ThreadPoolPublishModel;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerf;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroup;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroups;
import org.apache.servicecomb.metrics.core.publish.model.invocation.PerfInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class DefaultLogPublisher
implements MetricsInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"scb-metrics");
    public static final String ENABLED = "servicecomb.metrics.publisher.defaultLog.enabled";
    public static final String ENDPOINTS_CLIENT_DETAIL_ENABLED = "servicecomb.metrics.publisher.defaultLog.endpoints.client.detail.enabled";
    private static final String FIRST_LINE_SIMPLE_FORMAT = "  %-11s\n";
    private static final String SIMPLE_FORMAT = "              %-8.1f %-18s %s%s\n";
    private static final String PRODUCER_DETAILS_FORMAT = "        prepare: %-18s decode-request       : %-18s queue : %-18s business-execute: %s\n        encode-response: %-18s send: %-18s\n";
    private static final String CONSUMER_DETAILS_FORMAT = "        prepare     : %-18s connection : %-18s encode-request: %-18s send     : %s\n        wait  : %-18s decode-response    : %-18s\n";
    private static final String EDGE_DETAILS_FORMAT = "        prepare     : %-18s provider-decode       : %-18s connection : %-18s consumer-encode : %s\n        consumer-send : %-18s wait     : %-18s consumer-decode  : %-18s provider-encode    : %s\n        provider-send    : %-18s\n";
    private LatencyDistributionConfig latencyDistributionConfig;
    private String latencyDistributionHeader = "";
    private String latencyDistributionFormat = "";
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void init(MeterRegistry meterRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        if (!((Boolean)this.environment.getProperty(ENABLED, Boolean.TYPE, (Object)false)).booleanValue()) {
            return;
        }
        this.initLatencyDistribution(config);
        eventBus.register((Object)this);
    }

    private void initLatencyDistribution(MetricsBootstrapConfig config) {
        int leastLatencyScopeStrLength = config.getMinScopeLength();
        this.latencyDistributionConfig = new LatencyDistributionConfig(config.getLatencyDistribution());
        for (LatencyScopeConfig scopeConfig : this.latencyDistributionConfig.getScopeConfigs()) {
            String header = scopeConfig.getMsMax() == LatencyDistributionConfig.MAX_LATENCY.longValue() ? String.format("[%d,) ", scopeConfig.getMsMin()) : String.format("[%d,%d) ", scopeConfig.getMsMin(), scopeConfig.getMsMax());
            header = Strings.padEnd((String)header, (int)leastLatencyScopeStrLength, (char)' ');
            this.latencyDistributionHeader = this.latencyDistributionHeader + header;
            String format = "%-" + (header.length() - 1) + "d ";
            this.latencyDistributionFormat = this.latencyDistributionFormat + format;
        }
    }

    @Subscribe
    public void onPolledEvent(PolledEvent event) {
        try {
            this.printLog(event.getMeters());
        }
        catch (Throwable e) {
            LOGGER.error("Failed to print perf log.", e);
        }
    }

    protected void printLog(List<Meter> meters) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        PublishModelFactory factory = new PublishModelFactory(meters);
        DefaultPublishModel model = factory.createDefaultPublishModel();
        this.printOsLog(factory.getTree(), sb);
        this.printVertxMetrics(factory.getTree(), sb);
        this.printThreadPoolMetrics(model, sb);
        this.printConsumerLog(model, sb);
        this.printProducerLog(model, sb);
        this.printEdgeLog(model, sb);
        LOGGER.info(sb.toString());
    }

    protected void printOsLog(MeasurementTree tree, StringBuilder sb) {
        MeasurementNode osNode = tree.findChild("os");
        if (osNode == null || osNode.getMeasurements().isEmpty()) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"os:", (Object[])new Object[0]);
        this.printCpuLog(sb, osNode);
        this.printNetLog(sb, osNode);
    }

    private void printNetLog(StringBuilder sb, MeasurementNode osNode) {
        MeasurementNode netNode = osNode.findChild("net");
        if (netNode == null || netNode.getMeasurements().isEmpty()) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  net:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    send(Bps)    recv(Bps)    send(pps)    recv(pps)    interface", (Object[])new Object[0]);
        StringBuilder tmpSb = new StringBuilder();
        for (MeasurementNode interfaceNode : netNode.getChildren().values()) {
            double sendRate = interfaceNode.findChild(NetMeter.TAG_SEND.getValue()).summary();
            double sendPacketsRate = interfaceNode.findChild(NetMeter.TAG_PACKETS_SEND.getValue()).summary();
            double receiveRate = interfaceNode.findChild(NetMeter.TAG_RECEIVE.getValue()).summary();
            double receivePacketsRate = interfaceNode.findChild(NetMeter.TAG_PACKETS_RECEIVE.getValue()).summary();
            if (sendRate == 0.0 && receiveRate == 0.0 && receivePacketsRate == 0.0 && sendPacketsRate == 0.0) continue;
            StringBuilderUtils.appendLine((StringBuilder)tmpSb, (String)"    %-12s %-12s %-12s %-12s %s", (Object[])new Object[]{NetUtils.humanReadableBytes((long)((long)sendRate)), NetUtils.humanReadableBytes((long)((long)receiveRate)), NetUtils.humanReadableBytes((long)((long)sendPacketsRate)), NetUtils.humanReadableBytes((long)((long)receivePacketsRate)), interfaceNode.getName()});
        }
        if (tmpSb.length() != 0) {
            sb.append((CharSequence)tmpSb);
        }
    }

    private void printCpuLog(StringBuilder sb, MeasurementNode osNode) {
        MeasurementNode cpuNode = osNode.findChild("cpu");
        MeasurementNode processNode = osNode.findChild("processCpu");
        MeasurementNode memoryNode = osNode.findChild("memory");
        MeasurementNode slaNode = osNode.findChild("sla");
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  cpu:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    all usage: %.2f%%    process usage: %.2f%%    sla: %.2f    memory usage: %.2f%%", (Object[])new Object[]{cpuNode.summary() * 100.0, processNode.summary() * 100.0, slaNode.summary(), memoryNode.summary() * 100.0});
    }

    protected void printThreadPoolMetrics(DefaultPublishModel model, StringBuilder sb) {
        if (model.getThreadPools().isEmpty()) {
            return;
        }
        sb.append("threadPool:\n");
        sb.append("  coreSize maxThreads poolSize currentBusy rejected queueSize taskCount taskFinished name\n");
        for (Map.Entry<String, ThreadPoolPublishModel> entry : model.getThreadPools().entrySet()) {
            ThreadPoolPublishModel threadPoolPublishModel = entry.getValue();
            sb.append(String.format("  %-8d %-10d %-8d %-11d %-8.0f %-9d %-9.1f %-12.1f %s\n", threadPoolPublishModel.getCorePoolSize(), threadPoolPublishModel.getMaxThreads(), threadPoolPublishModel.getPoolSize(), threadPoolPublishModel.getCurrentThreadsBusy(), threadPoolPublishModel.getRejected(), threadPoolPublishModel.getQueueSize(), threadPoolPublishModel.getAvgTaskCount(), threadPoolPublishModel.getAvgCompletedTaskCount(), entry.getKey()));
        }
    }

    protected void printEdgeLog(DefaultPublishModel model, StringBuilder sb) {
        OperationPerfGroups edgePerf = model.getEdge().getOperationPerfGroups();
        if (edgePerf == null) {
            return;
        }
        sb.append("edge:\n simple:\n  status      requests      latency       ").append(this.latencyDistributionHeader).append("operation\n");
        StringBuilder detailsBuilder = new StringBuilder();
        for (Map<String, OperationPerfGroup> statusMap : edgePerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                sb.append((CharSequence)this.printSamplePerf(perfGroup));
                detailsBuilder.append((CharSequence)this.printEdgeDetailsPerf(perfGroup));
            }
        }
        sb.append(" details:\n").append((CharSequence)detailsBuilder);
    }

    protected void printConsumerLog(DefaultPublishModel model, StringBuilder sb) {
        OperationPerfGroups consumerPerf = model.getConsumer().getOperationPerfGroups();
        if (consumerPerf == null) {
            return;
        }
        sb.append("consumer:\n simple:\n  status      requests      latency       ").append(this.latencyDistributionHeader).append("operation\n");
        StringBuilder detailsBuilder = new StringBuilder();
        for (Map<String, OperationPerfGroup> statusMap : consumerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                sb.append((CharSequence)this.printSamplePerf(perfGroup));
                detailsBuilder.append((CharSequence)this.printConsumerDetailsPerf(perfGroup));
            }
        }
        sb.append(" details:\n").append((CharSequence)detailsBuilder);
    }

    protected void printProducerLog(DefaultPublishModel model, StringBuilder sb) {
        OperationPerfGroups producerPerf = model.getProducer().getOperationPerfGroups();
        if (producerPerf == null) {
            return;
        }
        sb.append("producer:\n simple:\n  status      requests      latency       ").append(this.latencyDistributionHeader).append("operation\n");
        StringBuilder detailsBuilder = new StringBuilder();
        for (Map<String, OperationPerfGroup> statusMap : producerPerf.getGroups().values()) {
            for (OperationPerfGroup perfGroup : statusMap.values()) {
                sb.append((CharSequence)this.printSamplePerf(perfGroup));
                detailsBuilder.append((CharSequence)this.printProducerDetailsPerf(perfGroup));
            }
        }
        sb.append(" details:\n").append((CharSequence)detailsBuilder);
    }

    private StringBuilder printSamplePerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        String status = perfGroup.getTransport() + "." + perfGroup.getStatus() + ":";
        sb.append(String.format(FIRST_LINE_SIMPLE_FORMAT, status));
        for (int i = 0; i < perfGroup.getOperationPerfs().size(); ++i) {
            OperationPerf operationPerf = perfGroup.getOperationPerfs().get(i);
            if (this.isIngoreEmptyPerf(operationPerf)) continue;
            PerfInfo stageTotal = operationPerf.findStage("total");
            sb.append(String.format(SIMPLE_FORMAT, stageTotal.getTotalRequests(), DefaultLogPublisher.getDetailsFromPerf(stageTotal), this.formatLatencyDistribution(operationPerf), operationPerf.getOperation()));
        }
        OperationPerf summaryOperation = perfGroup.getSummary();
        PerfInfo stageSummaryTotal = summaryOperation.findStage("total");
        sb.append(String.format(SIMPLE_FORMAT, stageSummaryTotal.getTotalRequests(), DefaultLogPublisher.getDetailsFromPerf(stageSummaryTotal), this.formatLatencyDistribution(summaryOperation), "(summary)"));
        return sb;
    }

    private String formatLatencyDistribution(OperationPerf operationPerf) {
        return String.format(this.latencyDistributionFormat, operationPerf.getLatencyDistribution());
    }

    private StringBuilder printProducerDetailsPerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(perfGroup.getTransport()).append(".").append(perfGroup.getStatus()).append(":\n");
        for (OperationPerf operationPerf : perfGroup.getOperationPerfs()) {
            if (this.isIngoreEmptyPerf(operationPerf)) continue;
            PerfInfo prepare = operationPerf.findStage("prepare");
            PerfInfo queue = operationPerf.findStage("queue");
            PerfInfo providerDecode = operationPerf.findStage("provider-decode");
            PerfInfo providerEncode = operationPerf.findStage("provider-encode");
            PerfInfo execute = operationPerf.findStage("execute");
            PerfInfo sendResp = operationPerf.findStage("provider-send");
            sb.append("      ").append(operationPerf.getOperation()).append(":\n").append(String.format(PRODUCER_DETAILS_FORMAT, DefaultLogPublisher.getDetailsFromPerf(prepare), DefaultLogPublisher.getDetailsFromPerf(providerDecode), DefaultLogPublisher.getDetailsFromPerf(queue), DefaultLogPublisher.getDetailsFromPerf(execute), DefaultLogPublisher.getDetailsFromPerf(providerEncode), DefaultLogPublisher.getDetailsFromPerf(sendResp)));
        }
        return sb;
    }

    private StringBuilder printConsumerDetailsPerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(perfGroup.getTransport()).append(".").append(perfGroup.getStatus()).append(":\n");
        for (OperationPerf operationPerf : perfGroup.getOperationPerfs()) {
            if (this.isIngoreEmptyPerf(operationPerf)) continue;
            PerfInfo prepare = operationPerf.findStage("prepare");
            PerfInfo encodeRequest = operationPerf.findStage("consumer-encode");
            PerfInfo decodeResponse = operationPerf.findStage("consumer-decode");
            PerfInfo sendReq = operationPerf.findStage("consumer-send");
            PerfInfo getConnect = operationPerf.findStage("connection");
            PerfInfo waitResp = operationPerf.findStage("wait");
            sb.append("      ").append(operationPerf.getOperation()).append(":\n").append(String.format(CONSUMER_DETAILS_FORMAT, DefaultLogPublisher.getDetailsFromPerf(prepare), DefaultLogPublisher.getDetailsFromPerf(getConnect), DefaultLogPublisher.getDetailsFromPerf(encodeRequest), DefaultLogPublisher.getDetailsFromPerf(sendReq), DefaultLogPublisher.getDetailsFromPerf(waitResp), DefaultLogPublisher.getDetailsFromPerf(decodeResponse)));
        }
        return sb;
    }

    private StringBuilder printEdgeDetailsPerf(OperationPerfGroup perfGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(perfGroup.getTransport()).append(".").append(perfGroup.getStatus()).append(":\n");
        for (OperationPerf operationPerf : perfGroup.getOperationPerfs()) {
            if (this.isIngoreEmptyPerf(operationPerf)) continue;
            PerfInfo prepare = operationPerf.findStage("prepare");
            PerfInfo connection = operationPerf.findStage("connection");
            PerfInfo decodeProviderRequest = operationPerf.findStage("provider-decode");
            PerfInfo encodeProviderResponse = operationPerf.findStage("provider-encode");
            PerfInfo encodeConsumerRequest = operationPerf.findStage("consumer-encode");
            PerfInfo sendReq = operationPerf.findStage("consumer-send");
            PerfInfo decodeConsumerResponse = operationPerf.findStage("consumer-decode");
            PerfInfo waitResp = operationPerf.findStage("wait");
            PerfInfo sendResp = operationPerf.findStage("provider-send");
            sb.append("      ").append(operationPerf.getOperation()).append(":\n").append(String.format(EDGE_DETAILS_FORMAT, DefaultLogPublisher.getDetailsFromPerf(prepare), DefaultLogPublisher.getDetailsFromPerf(decodeProviderRequest), DefaultLogPublisher.getDetailsFromPerf(connection), DefaultLogPublisher.getDetailsFromPerf(encodeConsumerRequest), DefaultLogPublisher.getDetailsFromPerf(sendReq), DefaultLogPublisher.getDetailsFromPerf(waitResp), DefaultLogPublisher.getDetailsFromPerf(decodeConsumerResponse), DefaultLogPublisher.getDetailsFromPerf(encodeProviderResponse), DefaultLogPublisher.getDetailsFromPerf(sendResp)));
        }
        return sb;
    }

    private boolean isIngoreEmptyPerf(OperationPerf operationPerf) {
        PerfInfo stageTotal = operationPerf.findStage("total");
        return Double.compare(0.0, stageTotal.getTotalRequests()) == 0 && Double.compare(0.0, stageTotal.getMsMaxLatency()) == 0;
    }

    protected void printVertxMetrics(MeasurementTree tree, StringBuilder sb) {
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"vertx:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  instances:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    name       eventLoopContext-created", (Object[])new Object[0]);
        for (Map.Entry entry : VertxUtils.getVertxMap().entrySet()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"    %-10s %d", (Object[])new Object[]{entry.getKey(), 0});
        }
        ClientEndpointsLogPublisher client = new ClientEndpointsLogPublisher(tree, sb, "client");
        ServerEndpointsLogPublisher server = new ServerEndpointsLogPublisher(tree, sb, "server");
        if (client.isExists() || server.isExists()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  transport:", (Object[])new Object[0]);
            if (client.isExists()) {
                client.print((Boolean)this.environment.getProperty(ENDPOINTS_CLIENT_DETAIL_ENABLED, Boolean.TYPE, (Object)true));
            }
            if (server.isExists()) {
                server.print(true);
            }
        }
    }

    private static String getDetailsFromPerf(PerfInfo perfInfo) {
        String result = "";
        if (perfInfo != null) {
            result = String.format("%.3f/%.3f", perfInfo.calcMsLatency(), perfInfo.getMsMaxLatency());
        }
        return result;
    }
}

