/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.net.ClientOptionsBase;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpClientConfig;
import org.apache.servicecomb.transport.highway.HighwayClientConnection;
import org.apache.servicecomb.transport.highway.HighwayClientConnectionPool;
import org.apache.servicecomb.transport.highway.HighwayClientPackage;
import org.apache.servicecomb.transport.highway.HighwayClientPoolFactory;
import org.apache.servicecomb.transport.highway.HighwayConfig;
import org.springframework.core.env.Environment;

public class HighwayClient {
    private static final String SSL_KEY = "highway.consumer";
    private ClientPoolManager<HighwayClientConnectionPool> clientMgr;

    public void init(Vertx vertx) throws Exception {
        TcpClientConfig normalConfig = this.createTcpClientConfig();
        normalConfig.setSsl(false);
        TcpClientConfig sslConfig = this.createTcpClientConfig();
        sslConfig.setSsl(true);
        this.clientMgr = new ClientPoolManager(vertx, (ClientPoolFactory)new HighwayClientPoolFactory(normalConfig, sslConfig));
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(this.clientMgr, (int)HighwayConfig.getClientThreadCount());
        Map result = VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deployOptions);
        if (!((Boolean)result.get("code")).booleanValue()) {
            throw new IllegalStateException((String)result.get("message"));
        }
    }

    @VisibleForTesting
    TcpClientConfig createTcpClientConfig() {
        TcpClientConfig tcpClientConfig = new TcpClientConfig();
        tcpClientConfig.setMsLoginTimeout(LegacyPropertyFactory.getLongProperty((String)"servicecomb.request.timeout", (long)30000L));
        SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)SSL_KEY, (Environment)LegacyPropertyFactory.getEnvironment());
        SSLOption sslOption = factory == null ? SSLOption.build((String)SSL_KEY, (Environment)LegacyPropertyFactory.getEnvironment()) : factory.createSSLOption();
        SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
        VertxTLSBuilder.buildClientOptionsBase((SSLOption)sslOption, (SSLCustom)sslCustom, (ClientOptionsBase)tcpClientConfig);
        return tcpClientConfig;
    }

    public HighwayClientPackage createClientPackage(Invocation invocation, OperationProtobuf operationProtobuf) {
        long msRequestTimeout = invocation.getOperationMeta().getConfig().getMsRequestTimeout();
        return new HighwayClientPackage(invocation, operationProtobuf, msRequestTimeout);
    }

    public HighwayClientConnection findClientPool(Invocation invocation) {
        return (HighwayClientConnection)((HighwayClientConnectionPool)((Object)this.clientMgr.findClientPool(invocation.isSync()))).findOrCreateClient(invocation.getEndpoint().getEndpoint());
    }
}

