/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.google.common.eventbus.Subscribe;
import io.vertx.core.http.HttpClientRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.springframework.core.env.Environment;

public class EdgeAddHeaderFilter
extends AbstractFilter
implements EdgeFilter {
    public static final String NAME = "edge-add-headers";
    private static final String PREFIX = "servicecomb.edge.filter.addHeader";
    private static final String KEY_ENABLED = "servicecomb.edge.filter.addHeader.enabled";
    private static final String KEY_HEADERS = "servicecomb.edge.filter.addHeader.allowedHeaders";
    private final Environment environment;
    private List<String> publicHeaders = new ArrayList<String>();
    private boolean enabled = false;

    public EdgeAddHeaderFilter(Environment environment) {
        this.environment = environment;
        this.init();
        EventManager.register((Object)((Object)this));
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (String changed : event.getChanged()) {
            if (!changed.startsWith(PREFIX)) continue;
            this.init();
            break;
        }
    }

    private void init() {
        this.enabled = (Boolean)this.environment.getProperty(KEY_ENABLED, Boolean.TYPE, (Object)false);
        String publicHeaderStr = this.environment.getProperty(KEY_HEADERS, "");
        String[] split = publicHeaderStr.split(",");
        if (split.length > 0) {
            this.publicHeaders = Arrays.asList(split);
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean enabledForTransport(String transport) {
        return this.enabled;
    }

    public int getOrder() {
        return 1991;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        RestClientTransportContext transportContext = (RestClientTransportContext)invocation.getTransportContext();
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenAccept(v -> this.addHeaders(invocation, (arg_0, arg_1) -> ((HttpClientRequest)transportContext.getHttpClientRequest()).putHeader(arg_0, arg_1)))).thenCompose(v -> nextNode.onFilter(invocation));
    }

    public void addHeaders(Invocation invocation, BiConsumer<String, String> headerAdder) {
        HttpServletRequestEx oldRequest = invocation.getRequestEx();
        this.publicHeaders.forEach(key -> {
            String value = oldRequest.getHeader(key);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                headerAdder.accept((String)key, value);
            }
        });
    }
}

