/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.core.Response;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationConfig;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParameters;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RestClientEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientEncoder.class);
    public static final int FORM_BUFFER_SIZE = 1024;

    public void encode(Invocation invocation) {
        try {
            invocation.getInvocationStageTrace().startConsumerEncodeRequest();
            EncoderSession encoderSession = new EncoderSession(invocation);
            encoderSession.doEncode();
            invocation.getInvocationStageTrace().finishConsumerEncodeRequest();
        }
        catch (Exception e) {
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "scb_rest_client.40000001", e.getMessage(), (Throwable)e);
        }
    }

    protected static void writeCharSequence(ByteBuf byteBuf, String value) {
        byteBuf.writeCharSequence((CharSequence)value, StandardCharsets.UTF_8);
    }

    public static Buffer genFileBoundaryBuffer(Part part, String name, String boundary) {
        ByteBuf byteBuf = Unpooled.buffer();
        RestClientEncoder.writeCharSequence(byteBuf, "\r\n--");
        RestClientEncoder.writeCharSequence(byteBuf, boundary);
        RestClientEncoder.writeCharSequence(byteBuf, "\r\nContent-Disposition: form-data; name=\"");
        RestClientEncoder.writeCharSequence(byteBuf, name);
        RestClientEncoder.writeCharSequence(byteBuf, "\"; filename=\"");
        RestClientEncoder.writeCharSequence(byteBuf, String.valueOf(part.getSubmittedFileName()));
        RestClientEncoder.writeCharSequence(byteBuf, "\"\r\n");
        RestClientEncoder.writeCharSequence(byteBuf, "Content-Type: ");
        RestClientEncoder.writeCharSequence(byteBuf, part.getContentType());
        RestClientEncoder.writeCharSequence(byteBuf, "\r\n");
        RestClientEncoder.writeCharSequence(byteBuf, "Content-Transfer-Encoding: binary\r\n");
        RestClientEncoder.writeCharSequence(byteBuf, "\r\n");
        return Buffer.buffer((ByteBuf)byteBuf);
    }

    public static Buffer genBoundaryEndBuffer(String boundary) {
        ByteBuf byteBuf = Unpooled.buffer();
        RestClientEncoder.writeCharSequence(byteBuf, "\r\n--");
        RestClientEncoder.writeCharSequence(byteBuf, boundary);
        RestClientEncoder.writeCharSequence(byteBuf, "--\r\n");
        return Buffer.buffer((ByteBuf)byteBuf);
    }

    public static class EncoderSession {
        protected final Invocation invocation;
        protected final RestClientTransportContext transportContext;
        protected final RestClientRequestParameters requestParameters;
        protected final HttpClientRequest httpClientRequest;

        public EncoderSession(Invocation invocation) {
            this.invocation = invocation;
            this.transportContext = (RestClientTransportContext)invocation.getTransportContext();
            this.requestParameters = this.transportContext.getRequestParameters();
            this.httpClientRequest = this.transportContext.getHttpClientRequest();
        }

        protected void doEncode() throws Exception {
            LOGGER.debug("encode rest client request, operation={}, method={}, endpoint={}, uri={}.", new Object[]{this.invocation.getMicroserviceQualifiedName(), this.httpClientRequest.getMethod(), this.invocation.getEndpoint().getEndpoint(), this.httpClientRequest.getURI()});
            this.swaggerArgumentsToRequest();
            this.writeCookies(this.requestParameters.getCookieMap());
            this.writeScbHeaders();
            this.writeForm(this.requestParameters.getFormMap());
        }

        protected void swaggerArgumentsToRequest() throws Exception {
            RestCodec.argsToRest((Map)this.invocation.getSwaggerArguments(), (RestOperationMeta)this.transportContext.getRestOperationMeta(), (RestClientRequest)this.requestParameters);
        }

        protected void writeCookies(Map<String, String> cookieMap) {
            if (CollectionUtils.isEmpty(cookieMap)) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : cookieMap.entrySet()) {
                builder.append(entry.getKey()).append('=').append(entry.getValue()).append("; ");
            }
            StringBuilderUtils.deleteLast((StringBuilder)builder, (int)2);
            this.httpClientRequest.putHeader("Cookie", builder.toString());
        }

        protected void writeScbHeaders() throws JsonProcessingException {
            OperationConfig operationConfig = this.invocation.getOperationMeta().getConfig();
            if (operationConfig.isClientRequestHeaderFilterEnabled()) {
                return;
            }
            this.httpClientRequest.putHeader("x-cse-target-microservice", this.invocation.getMicroserviceName());
            this.httpClientRequest.putHeader("x-cse-context", RestObjectMapperFactory.getRestObjectMapper().writeValueAsString((Object)this.invocation.getContext()));
        }

        protected void writeForm(Map<String, Object> formMap) throws Exception {
            if (this.requestParameters.getUploads() == null) {
                this.writeUrlEncodedForm(formMap);
                return;
            }
            this.writeChunkedForm(formMap);
        }

        protected void writeUrlEncodedForm(Map<String, Object> formMap) throws Exception {
            if (formMap == null) {
                return;
            }
            this.httpClientRequest.putHeader("Content-Type", "application/x-www-form-urlencoded");
            Buffer bodyBuffer = this.genUrlEncodedFormBuffer(formMap);
            this.requestParameters.setBodyBuffer(bodyBuffer);
        }

        protected Buffer genUrlEncodedFormBuffer(Map<String, Object> formMap) throws Exception {
            ByteBuf byteBuf = Unpooled.buffer((int)1024);
            for (Map.Entry<String, Object> entry : formMap.entrySet()) {
                RestClientEncoder.writeCharSequence(byteBuf, entry.getKey());
                byteBuf.writeByte(61);
                String value = QueryCodec.convertToString((Object)entry.getValue());
                String encodedValue = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                RestClientEncoder.writeCharSequence(byteBuf, encodedValue);
                byteBuf.markWriterIndex();
                byteBuf.writeByte(38);
            }
            byteBuf.resetWriterIndex();
            return Buffer.buffer((ByteBuf)byteBuf);
        }

        protected void writeChunkedForm(Map<String, Object> formMap) throws Exception {
            String boundary = this.transportContext.getOrCreateBoundary();
            this.httpClientRequest.setChunked(true);
            this.httpClientRequest.putHeader("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
            if (formMap == null) {
                return;
            }
            Buffer bodyBuffer = this.genChunkedFormBuffer(formMap, boundary);
            this.requestParameters.setBodyBuffer(bodyBuffer);
        }

        protected Buffer genChunkedFormBuffer(Map<String, Object> formMap, String boundary) throws Exception {
            ByteBuf byteBuf = Unpooled.buffer((int)1024);
            for (Map.Entry<String, Object> entry : formMap.entrySet()) {
                RestClientEncoder.writeCharSequence(byteBuf, "\r\n--");
                RestClientEncoder.writeCharSequence(byteBuf, boundary);
                RestClientEncoder.writeCharSequence(byteBuf, "\r\nContent-Disposition: form-data; name=\"");
                RestClientEncoder.writeCharSequence(byteBuf, entry.getKey());
                RestClientEncoder.writeCharSequence(byteBuf, "\"\r\n\r\n");
                String value = QueryCodec.convertToString((Object)entry.getValue());
                RestClientEncoder.writeCharSequence(byteBuf, value);
            }
            return Buffer.buffer((ByteBuf)byteBuf);
        }
    }
}

