/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.cc;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.config.DynamicPropertiesSource;
import org.apache.servicecomb.config.cc.ConfigCenterConfig;
import org.apache.servicecomb.config.cc.TransportUtils;
import org.apache.servicecomb.config.center.client.ConfigCenterAddressManager;
import org.apache.servicecomb.config.center.client.ConfigCenterClient;
import org.apache.servicecomb.config.center.client.ConfigCenterConfigurationChangedEvent;
import org.apache.servicecomb.config.center.client.ConfigCenterManager;
import org.apache.servicecomb.config.center.client.model.ConfigCenterConfiguration;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsRequest;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsResponse;
import org.apache.servicecomb.config.common.ConfigConverter;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class ConfigCenterDynamicPropertiesSource
implements DynamicPropertiesSource {
    public static final String SOURCE_NAME = "config-center";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterDynamicPropertiesSource.class);
    private final Map<String, Object> data = new ConcurrentHashMapEx();
    private ConfigConverter configConverter;

    private void init(Environment environment) {
        ConfigCenterConfig configCenterConfig = new ConfigCenterConfig(environment);
        this.configConverter = new ConfigConverter(configCenterConfig.getFileSources());
        ConfigCenterAddressManager configCenterAddressManager = this.configCenterAddressManager(configCenterConfig);
        HttpTransport httpTransport = this.createHttpTransport(configCenterAddressManager, HttpTransportFactory.defaultRequestConfig().build(), environment, configCenterConfig);
        ConfigCenterClient configCenterClient = new ConfigCenterClient(configCenterAddressManager, httpTransport);
        EventManager.register((Object)this);
        ConfigCenterConfiguration configCenterConfiguration = this.createConfigCenterConfiguration(configCenterConfig);
        QueryConfigurationsRequest queryConfigurationsRequest = this.firstPull(configCenterConfig, configCenterClient, environment, configCenterAddressManager);
        ConfigCenterManager configCenterManager = new ConfigCenterManager(configCenterClient, EventManager.getEventBus(), this.configConverter, configCenterConfiguration, configCenterAddressManager);
        configCenterManager.setQueryConfigurationsRequest(queryConfigurationsRequest);
        configCenterManager.startConfigCenterManager();
        this.data.putAll(this.configConverter.getCurrentData());
    }

    private QueryConfigurationsRequest firstPull(ConfigCenterConfig configCenterConfig, ConfigCenterClient configCenterClient, Environment environment, ConfigCenterAddressManager configCenterAddressManager) {
        QueryConfigurationsRequest queryConfigurationsRequest = this.createQueryConfigurationsRequest(environment);
        try {
            QueryConfigurationsResponse response = configCenterClient.queryConfigurations(queryConfigurationsRequest, configCenterAddressManager.address());
            if (response.isChanged()) {
                this.configConverter.updateData(response.getConfigurations());
                queryConfigurationsRequest.setRevision(response.getRevision());
            }
        }
        catch (Exception e) {
            if (configCenterConfig.firstPullRequired()) {
                throw e;
            }
            LOGGER.warn("first pull failed, and ignore {}", (Object)e.getMessage());
        }
        return queryConfigurationsRequest;
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigCenterConfigurationChangedEvent event) {
        LOGGER.info("Dynamic configuration changed: {}", (Object)event.getChanged());
        this.data.putAll(event.getAdded());
        this.data.putAll(event.getUpdated());
        event.getDeleted().forEach((k, v) -> this.data.remove(k));
        EventManager.post((Object)ConfigurationChangedEvent.createIncremental((Map)event.getAdded(), (Map)event.getUpdated(), (Map)event.getDeleted()));
    }

    private QueryConfigurationsRequest createQueryConfigurationsRequest(Environment environment) {
        QueryConfigurationsRequest request = new QueryConfigurationsRequest();
        request.setApplication(BootStrapProperties.readApplication((Environment)environment));
        request.setServiceName(BootStrapProperties.readServiceName((Environment)environment));
        request.setVersion(BootStrapProperties.readServiceVersion((Environment)environment));
        request.setEnvironment(BootStrapProperties.readServiceEnvironment((Environment)environment));
        request.setRevision(null);
        return request;
    }

    private ConfigCenterConfiguration createConfigCenterConfiguration(ConfigCenterConfig configCenterConfig) {
        return new ConfigCenterConfiguration().setRefreshIntervalInMillis(configCenterConfig.getRefreshInterval());
    }

    private HttpTransport createHttpTransport(ConfigCenterAddressManager configCenterAddressManager, RequestConfig requestConfig, Environment environment, ConfigCenterConfig configCenterConfig) {
        List authHeaderProviders = SPIServiceUtils.getOrLoadSortedService(AuthHeaderProvider.class);
        if (configCenterConfig.isProxyEnable().booleanValue()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
            HttpHost proxy = new HttpHost(configCenterConfig.getProxyHost(), configCenterConfig.getProxyPort(), "http");
            httpClientBuilder.setProxy(proxy);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(configCenterConfig.getProxyUsername(), configCenterConfig.getProxyPasswd()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(configCenterAddressManager.sslEnabled(), environment, "cc.consumer"), (RequestAuthHeaderProvider)ConfigCenterDynamicPropertiesSource.getRequestAuthHeaderProvider(authHeaderProviders), (HttpClientBuilder)httpClientBuilder);
        }
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(configCenterAddressManager.sslEnabled(), environment, "cc.consumer"), (RequestAuthHeaderProvider)ConfigCenterDynamicPropertiesSource.getRequestAuthHeaderProvider(authHeaderProviders), (RequestConfig)requestConfig);
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }

    private ConfigCenterAddressManager configCenterAddressManager(ConfigCenterConfig configCenterConfig) {
        return new ConfigCenterAddressManager(configCenterConfig.getDomainName(), configCenterConfig.getServerUri(), EventManager.getEventBus());
    }

    public MapPropertySource create(Environment environment) {
        this.init(environment);
        return new MapPropertySource(SOURCE_NAME, this.data);
    }

    public int getOrder() {
        return 200;
    }
}

