/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultServerEndpointMetric;
import org.apache.servicecomb.metrics.core.meter.vertx.EndpointMeter;

public class ServerEndpointMeter
extends EndpointMeter {
    public static final String REJECT_BY_CONNECTION_LIMIT = "rejectByConnectionLimit";
    private long lastRejectByConnectionLimit;
    private long currentRejectByConnectionLimit;

    public ServerEndpointMeter(MeterRegistry meterRegistry, String name, Tags tags, DefaultEndpointMetric metric) {
        super(meterRegistry, name, tags, metric);
        Gauge.builder((String)name, () -> this.currentRejectByConnectionLimit).tags((Iterable)tags.and(new Tag[]{Tag.of((String)"statistic", (String)REJECT_BY_CONNECTION_LIMIT), Tag.of((String)"address", (String)metric.getAddress())})).register(meterRegistry);
    }

    @Override
    public void poll(long msNow, long secondInterval) {
        super.poll(msNow, secondInterval);
        long current = ((DefaultServerEndpointMetric)this.metric).getRejectByConnectionLimitCount();
        this.currentRejectByConnectionLimit = current - this.lastRejectByConnectionLimit;
        this.lastRejectByConnectionLimit = current;
    }
}

