/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;

public class EndpointMeter
implements PeriodMeter {
    private static final double SNV_MILLI_SECONDS = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    public static final String ADDRESS = "address";
    public static final String STATISTIC = "statistic";
    public static final String CONNECT_COUNT = "connectCount";
    public static final String DISCONNECT_COUNT = "disconnectCount";
    public static final String CONNECTIONS = "connections";
    public static final String BYTES_READ = "bytesRead";
    public static final String BYTES_WRITTEN = "bytesWritten";
    public static final String REQUESTS = "requests";
    public static final String LATENCY = "latency";
    protected DefaultEndpointMetric metric;
    private final MeterRegistry meterRegistry;
    private final Gauge connectCount;
    private final Gauge disconnectCount;
    private final Gauge connections;
    private final Gauge bytesRead;
    private final Gauge bytesWritten;
    private final Gauge requests;
    private final Gauge latency;
    private long currentConnectCount;
    private long lastConnectCount;
    private long currentDisconnectCount;
    private long lastDisconnectCount;
    private long currentBytesRead;
    private long lastBytesRead;
    private long currentBytesWritten;
    private long lastBytesWritten;
    private long currentRequests;
    private long lastRequests;
    private long currentRequestsForLatency;
    private long lastRequestsForLatency;
    private long currentLatency;
    private long lastLatency;

    public EndpointMeter(MeterRegistry meterRegistry, String name, Tags tags, DefaultEndpointMetric metric) {
        this.meterRegistry = meterRegistry;
        this.metric = metric;
        tags = tags.and(new Tag[]{Tag.of((String)ADDRESS, (String)metric.getAddress())});
        this.connectCount = Gauge.builder((String)name, () -> this.currentConnectCount).tags((Iterable)tags.and(new Tag[]{Tag.of((String)STATISTIC, (String)CONNECT_COUNT)})).register(meterRegistry);
        this.disconnectCount = Gauge.builder((String)name, () -> this.currentDisconnectCount).tags((Iterable)tags.and(new Tag[]{Tag.of((String)STATISTIC, (String)DISCONNECT_COUNT)})).register(meterRegistry);
        this.connections = Gauge.builder((String)name, () -> this.metric.getConnectCount() - this.metric.getDisconnectCount()).tags((Iterable)tags.and(new Tag[]{Tag.of((String)STATISTIC, (String)CONNECTIONS)})).register(meterRegistry);
        this.bytesRead = Gauge.builder((String)name, () -> this.currentBytesRead).tags((Iterable)tags.and(new Tag[]{Tag.of((String)STATISTIC, (String)BYTES_READ)})).register(meterRegistry);
        this.bytesWritten = Gauge.builder((String)name, () -> this.currentBytesWritten).tags((Iterable)tags.and(new Tag[]{Tag.of((String)STATISTIC, (String)BYTES_WRITTEN)})).register(meterRegistry);
        this.requests = Gauge.builder((String)name, () -> this.currentRequests).tags((Iterable)tags.and(new Tag[]{Tag.of((String)STATISTIC, (String)REQUESTS)})).register(meterRegistry);
        this.latency = Gauge.builder((String)name, () -> this.currentRequestsForLatency == 0L ? 0.0 : (double)this.currentLatency / (double)this.currentRequestsForLatency * SNV_MILLI_SECONDS).tags((Iterable)tags.and(new Tag[]{Tag.of((String)STATISTIC, (String)LATENCY)})).register(meterRegistry);
    }

    public DefaultEndpointMetric getMetric() {
        return this.metric;
    }

    public void destroy() {
        this.meterRegistry.remove((Meter)this.connectCount);
        this.meterRegistry.remove((Meter)this.disconnectCount);
        this.meterRegistry.remove((Meter)this.connections);
        this.meterRegistry.remove((Meter)this.bytesRead);
        this.meterRegistry.remove((Meter)this.bytesWritten);
        this.meterRegistry.remove((Meter)this.requests);
        this.meterRegistry.remove((Meter)this.latency);
    }

    public void poll(long msNow, long secondInterval) {
        long temp = this.metric.getConnectCount();
        this.currentConnectCount = temp - this.lastConnectCount;
        this.lastConnectCount = temp;
        temp = this.metric.getDisconnectCount();
        this.currentDisconnectCount = temp - this.lastDisconnectCount;
        this.lastDisconnectCount = temp;
        temp = this.metric.getBytesRead();
        this.currentBytesRead = temp - this.lastBytesRead;
        this.lastBytesRead = temp;
        temp = this.metric.getBytesWritten();
        this.currentBytesWritten = temp - this.lastBytesWritten;
        this.lastBytesWritten = temp;
        temp = this.metric.getRequests();
        this.currentRequests = temp - this.lastRequests;
        this.lastRequests = temp;
        temp = this.metric.getRequests();
        this.currentRequestsForLatency = temp - this.lastRequestsForLatency;
        this.lastRequestsForLatency = temp;
        temp = this.metric.getLatency();
        this.currentLatency = temp - this.lastLatency;
        this.lastLatency = temp;
    }
}

