/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.metrics.core.meter.invocation.AbstractInvocationMeter;

public class ConsumerInvocationMeter
extends AbstractInvocationMeter {
    private final Timer consumerEncodeRequestTimer;
    private final Timer consumerDecodeResponseTimer;
    private final Timer consumerGetConnectionTimer;
    private final Timer consumerSendRequestTimer;
    private final Timer consumerWaitResponseTimer;

    public ConsumerInvocationMeter(MeterRegistry meterRegistry, String name, Tags tags, MetricsBootstrapConfig metricsBootstrapConfig) {
        super(meterRegistry, name, tags, metricsBootstrapConfig);
        this.consumerSendRequestTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "consumer-send"})).register(meterRegistry);
        this.consumerGetConnectionTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "connection"})).register(meterRegistry);
        this.consumerEncodeRequestTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "consumer-encode"})).register(meterRegistry);
        this.consumerDecodeResponseTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "consumer-decode"})).register(meterRegistry);
        this.consumerWaitResponseTimer = Timer.builder((String)name).tags((Iterable)tags.and(new String[]{"type", "stage", "stage", "wait"})).register(meterRegistry);
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        super.onInvocationFinish(event);
        InvocationStageTrace invocationStageTrace = event.getInvocation().getInvocationStageTrace();
        this.consumerEncodeRequestTimer.record(invocationStageTrace.calcConsumerEncodeRequest(), TimeUnit.NANOSECONDS);
        this.consumerSendRequestTimer.record(invocationStageTrace.calcConsumerSendRequest(), TimeUnit.NANOSECONDS);
        this.consumerGetConnectionTimer.record(invocationStageTrace.calcConnection(), TimeUnit.NANOSECONDS);
        this.consumerWaitResponseTimer.record(invocationStageTrace.calcWait(), TimeUnit.NANOSECONDS);
        this.consumerDecodeResponseTimer.record(invocationStageTrace.calcConsumerDecodeResponse(), TimeUnit.NANOSECONDS);
    }
}

