/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.util.List;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsFactory;
import org.apache.servicecomb.loadbalance.RoundRobinRuleExt;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionsManager.class);
    private final List<ExtensionsFactory> extensionsFactories;

    public ExtensionsManager(List<ExtensionsFactory> extensionsFactories) {
        this.extensionsFactories = extensionsFactories;
    }

    public RuleExt createLoadBalancerRule(String microservice) {
        RuleExt rule = null;
        for (ExtensionsFactory factory : this.extensionsFactories) {
            if (!factory.isSupport("strategy.name", Configuration.INSTANCE.getRuleStrategyName(microservice))) continue;
            rule = factory.createLoadBalancerRule(Configuration.INSTANCE.getRuleStrategyName(microservice));
            break;
        }
        if (rule == null) {
            rule = new RoundRobinRuleExt();
        }
        LOGGER.info("Using load balance rule {} for microservice {}.", (Object)rule.getClass().getName(), (Object)microservice);
        return rule;
    }
}

