/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import org.apache.servicecomb.swagger.generator.core.OperationGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class ParameterGeneratorContext
extends OperationGeneratorContext {
    private JavaType parameterType;
    private String parameterName;
    private HttpParameterType httpParameterType;
    private Boolean explode;
    private Boolean required;
    private Object defaultValue;
    private Boolean rawJson;
    private Schema<?> schema;

    public ParameterGeneratorContext(OperationGeneratorContext parent) {
        super(parent);
    }

    public JavaType getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(JavaType parameterType) {
        this.parameterType = parameterType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getRawJson() {
        return this.rawJson;
    }

    public void setRawJson(Boolean rawJson) {
        this.rawJson = rawJson;
    }

    public Schema<?> getSchema() {
        return this.schema;
    }

    public void setSchema(Schema<?> schema) {
        this.schema = schema;
    }

    public HttpParameterType getHttpParameterType() {
        return this.httpParameterType;
    }

    public void setHttpParameterType(HttpParameterType httpParameterType) {
        this.httpParameterType = httpParameterType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void updateConsumes(boolean isForm, boolean isBinary) {
        ArrayList<String> removed = new ArrayList<String>();
        if (this.httpParameterType == HttpParameterType.BODY) {
            if (isForm) {
                throw new IllegalArgumentException("Both form and body parameter not allowed.");
            }
            for (String media : this.supportedConsumes) {
                if (SUPPORTED_BODY_CONTENT_TYPE.contains(media)) continue;
                removed.add(media);
            }
        } else if (this.httpParameterType == HttpParameterType.FORM) {
            for (String media : this.supportedConsumes) {
                if (!SUPPORTED_FORM_CONTENT_TYPE.contains(media)) {
                    removed.add(media);
                    continue;
                }
                if (isBinary && this.supportedConsumes.contains("application/x-www-form-urlencoded")) {
                    removed.add("application/x-www-form-urlencoded");
                }
                if (isBinary || !this.supportedConsumes.contains("multipart/form-data")) continue;
                removed.add("multipart/form-data");
            }
        } else {
            this.supportedConsumes.clear();
        }
        this.supportedConsumes.removeAll(removed);
    }

    public boolean isForm() {
        return this.httpParameterType == HttpParameterType.FORM;
    }

    public boolean isBinary() {
        if ("string".equals(this.schema.getType()) && "binary".equals(this.schema.getFormat())) {
            return true;
        }
        return "array".equals(this.schema.getType()) && "string".equals(this.schema.getItems().getType()) && "binary".equals(this.schema.getItems().getFormat());
    }

    public boolean isObject() {
        return "object".equals(this.schema.getType());
    }
}

