/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.registry.api.AbstractDiscoveryInstance;
import org.apache.servicecomb.registry.api.DataCenterInfo;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.springframework.core.env.Environment;

public class NacosDiscoveryInstance
extends AbstractDiscoveryInstance {
    private final Instance instance;
    private final String application;
    private final String serviceName;
    private final Environment environment;
    private final Map<String, String> schemas;
    private final List<String> endpoints;

    public NacosDiscoveryInstance(Instance instance, String application, String serviceName, Environment environment) {
        this.instance = instance;
        this.environment = environment;
        this.application = application;
        this.serviceName = serviceName;
        this.endpoints = NacosDiscoveryInstance.readEndpoints(instance);
        this.schemas = NacosDiscoveryInstance.readSchemas(instance);
    }

    public MicroserviceInstanceStatus getStatus() {
        return this.instance.isEnabled() ? MicroserviceInstanceStatus.UP : MicroserviceInstanceStatus.DOWN;
    }

    public String getRegistryName() {
        return "nacos-registry";
    }

    public String getEnvironment() {
        return BootStrapProperties.readServiceEnvironment((Environment)this.environment);
    }

    public String getApplication() {
        return this.application;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAlias() {
        return (String)this.instance.getMetadata().get("scb-alias");
    }

    public String getVersion() {
        return (String)this.instance.getMetadata().get("scb-version");
    }

    public DataCenterInfo getDataCenterInfo() {
        DataCenterInfo dataCenterInfo = new DataCenterInfo();
        dataCenterInfo.setRegion((String)this.instance.getMetadata().get("scb-region"));
        dataCenterInfo.setAvailableZone((String)this.instance.getMetadata().get("scb-zone"));
        dataCenterInfo.setName((String)this.instance.getMetadata().get("scb-datacenter"));
        return dataCenterInfo;
    }

    public String getDescription() {
        return (String)this.instance.getMetadata().get("scb-description");
    }

    public Map<String, String> getProperties() {
        return this.instance.getMetadata();
    }

    public Map<String, String> getSchemas() {
        return this.schemas;
    }

    private static Map<String, String> readSchemas(Instance instance) {
        Map metaData = instance.getMetadata();
        HashMap<String, String> instanceSchemas = new HashMap<String, String>();
        for (Map.Entry entry : metaData.entrySet()) {
            if (!((String)entry.getKey()).startsWith("scb-schema-")) continue;
            instanceSchemas.put(((String)entry.getKey()).substring("scb-schema-".length()), (String)entry.getValue());
        }
        return instanceSchemas;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    private static List<String> readEndpoints(Instance instance) {
        if (StringUtils.isEmpty((CharSequence)((CharSequence)instance.getMetadata().get("scb-endpoint")))) {
            if (StringUtils.isNotEmpty((CharSequence)instance.getIp()) && instance.getPort() > 0) {
                return List.of("rest://" + instance.getIp() + ":" + instance.getPort());
            }
            return Collections.emptyList();
        }
        return Arrays.asList(((String)instance.getMetadata().get("scb-endpoint")).split(","));
    }

    public String getInstanceId() {
        return this.instance.getInstanceId();
    }
}

