/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.invocation.Response;

public class FilterNode {
    public static final FilterNode EMPTY = new FilterNode(null){

        @Override
        public CompletableFuture<Response> onFilter(Invocation invocation) {
            return CompletableFuture.completedFuture(Response.ok(null));
        }
    };
    private final Filter filter;
    private FilterNode nextNode;

    public static FilterNode buildChain(Filter ... filters) {
        return FilterNode.buildChain(Arrays.asList(filters));
    }

    public static FilterNode buildChain(List<Filter> filters) {
        List<FilterNode> filterNodes = filters.stream().map(FilterNode::new).toList();
        for (int idx = 0; idx < filterNodes.size() - 1; ++idx) {
            FilterNode currentNode = filterNodes.get(idx);
            FilterNode nextNode = filterNodes.get(idx + 1);
            currentNode.setNextNode(nextNode);
        }
        return filterNodes.get(0);
    }

    public FilterNode(Filter filter) {
        this.filter = filter;
    }

    private void setNextNode(FilterNode nextNode) {
        this.nextNode = nextNode;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation) {
        if (invocation.getTransportName() != null && !this.filter.enabledForTransport(invocation.getTransportName())) {
            return this.nextNode.onFilter(invocation);
        }
        String stage = invocation.getInvocationStageTrace().recordStageBegin(this.filter.getNameWithOrder());
        return AsyncUtils.tryCatchSupplierFuture(() -> this.filter.onFilter(invocation, this.nextNode).whenComplete((r, e) -> invocation.getInvocationStageTrace().recordStageEnd(stage))).thenApply(this::rethrowExceptionInResponse);
    }

    private Response rethrowExceptionInResponse(Response response) {
        if (response.isFailed() && response.getResult() instanceof Throwable) {
            throw AsyncUtils.rethrow((Throwable)((Throwable)response.getResult()));
        }
        return response;
    }
}

