/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.provider;

import jakarta.ws.rs.core.Response;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.authentication.provider.ProviderTokenManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.beans.factory.annotation.Autowired;

public class ProviderAuthFilter
extends AbstractFilter
implements ProviderFilter {
    private ProviderTokenManager authenticationTokenManager;

    @Autowired
    public void setProviderTokenManager(ProviderTokenManager providerTokenManager) {
        this.authenticationTokenManager = providerTokenManager;
    }

    public int getOrder() {
        return 1010;
    }

    public String getName() {
        return "provider-public-key";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        String token = invocation.getContext("x-cse-auth-rsatoken");
        if (null != token && this.authenticationTokenManager.valid(token)) {
            return nextNode.onFilter(invocation);
        }
        return CompletableFuture.failedFuture((Throwable)new InvocationException((Response.StatusType)Response.Status.UNAUTHORIZED, "public key authorization failed."));
    }
}

