/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.produce;

import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProtoBufferProcessor;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProduceProcessorManager
extends RegisterManager<String, Map<String, ProduceProcessor>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProduceProcessorManager.class);
    private static final List<ProduceProcessor> produceProcessor = SPIServiceUtils.getSortedService(ProduceProcessor.class);
    private static final String NAME = "produce processor mgr";
    public static final String DEFAULT_SERIAL_CLASS = "servicecomb_default_class";
    public static final ProduceProcessorManager INSTANCE = new ProduceProcessorManager();
    private final Map<String, ProduceProcessor> jsonProcessorMap;
    private final Map<String, ProduceProcessor> plainProcessorMap;
    private final Map<String, ProduceProcessor> defaultProcessorMap;

    private ProduceProcessorManager() {
        super(NAME);
        produceProcessor.forEach(processor -> {
            Map prodProcessorMap = this.getObjMap().computeIfAbsent(processor.getName(), key -> new HashMap());
            prodProcessorMap.putIfAbsent(processor.getSerializationView(), processor);
        });
        this.jsonProcessorMap = (Map)this.ensureFindValue("application/json");
        this.plainProcessorMap = (Map)this.ensureFindValue("text/plain");
        this.defaultProcessorMap = this.jsonProcessorMap;
    }

    private static ProduceProcessor cloneNewProduceProcessor(Class<?> serialViewClass, Map<String, ProduceProcessor> produceViewMap) {
        try {
            ProduceProcessor newInstance = (ProduceProcessor)produceViewMap.get(DEFAULT_SERIAL_CLASS).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            newInstance.setSerializationView(serialViewClass);
            return newInstance;
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to create produceProcessor with {}", (Object)serialViewClass.getName(), (Object)e);
            return produceViewMap.get(DEFAULT_SERIAL_CLASS);
        }
    }

    public ProduceProcessor findJsonProcessorByViewClass(Class<?> serialViewClass) {
        if (serialViewClass == null) {
            return this.jsonProcessorMap.get(DEFAULT_SERIAL_CLASS);
        }
        return this.jsonProcessorMap.computeIfAbsent(serialViewClass.getName(), viewKey -> ProduceProcessorManager.cloneNewProduceProcessor(serialViewClass, this.jsonProcessorMap));
    }

    public ProduceProcessor findPlainProcessorByViewClass(Class<?> serialViewClass) {
        if (serialViewClass == null) {
            return this.plainProcessorMap.get(DEFAULT_SERIAL_CLASS);
        }
        return this.plainProcessorMap.computeIfAbsent(serialViewClass.getName(), viewKey -> ProduceProcessorManager.cloneNewProduceProcessor(serialViewClass, this.plainProcessorMap));
    }

    public ProduceProcessor findDefaultJsonProcessor() {
        return this.jsonProcessorMap.get(DEFAULT_SERIAL_CLASS);
    }

    public ProduceProcessor findDefaultProcessor() {
        return this.defaultProcessorMap.get(DEFAULT_SERIAL_CLASS);
    }

    public ProduceProcessor findDefaultPlainProcessor() {
        return this.plainProcessorMap.get(DEFAULT_SERIAL_CLASS);
    }

    public ProduceProcessor createProduceProcessor(OperationMeta operationMeta, int statusCode, String accept, Class<?> serialViewClass) {
        ApiResponses responses = operationMeta.getSwaggerOperation().getResponses();
        ApiResponse response = (ApiResponse)responses.get((Object)String.valueOf(statusCode));
        if (response == null || response.getContent() == null || response.getContent().size() == 0) {
            return this.findDefaultProcessor();
        }
        String actualAccept = accept;
        if (actualAccept == null) {
            actualAccept = response.getContent().get((Object)"application/json") != null ? "application/json" : (String)response.getContent().keySet().iterator().next();
        }
        ContentType contentType = ContentType.parse((String)actualAccept);
        actualAccept = contentType.getMimeType();
        if ("*/*".equals(contentType.getMimeType()) || "*".equals(contentType.getMimeType())) {
            actualAccept = response.getContent().get((Object)"application/json") != null ? "application/json" : (String)response.getContent().keySet().iterator().next();
        }
        if (response.getContent().get((Object)actualAccept) == null) {
            LOGGER.warn("Operation do not support accept type {}/{}", (Object)accept, (Object)actualAccept);
            return this.findDefaultProcessor();
        }
        if ("application/protobuf".equals(actualAccept)) {
            return new ProduceProtoBufferProcessor(operationMeta, operationMeta.getSchemaMeta().getSwagger(), ((MediaType)response.getContent().get((Object)actualAccept)).getSchema());
        }
        if ("text/plain".equals(actualAccept)) {
            return this.findPlainProcessorByViewClass(serialViewClass);
        }
        return this.findJsonProcessorByViewClass(serialViewClass);
    }
}

