/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import com.google.common.collect.Multimap;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.streams.WriteStream;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.vertx.executor.VertxContextExecutor;
import org.apache.servicecomb.foundation.vertx.http.ReadStreamPart;
import org.apache.servicecomb.foundation.vertx.stream.PumpFromPart;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.transport.rest.client.RestClientEncoder;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParameters;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientSender.class);
    protected final Invocation invocation;
    protected final RestClientTransportContext transportContext;
    protected final RestClientRequestParameters requestParameters;
    protected final HttpClientRequest httpClientRequest;
    protected final CompletableFuture<Response> future = new CompletableFuture();

    public RestClientSender(Invocation invocation) {
        this.invocation = invocation;
        this.transportContext = (RestClientTransportContext)invocation.getTransportContext();
        this.requestParameters = this.transportContext.getRequestParameters();
        this.httpClientRequest = this.transportContext.getHttpClientRequest();
    }

    public CompletableFuture<Response> send() {
        this.invocation.getInvocationStageTrace().startConsumerSendRequest();
        this.httpClientRequest.response().compose(response -> this.processResponse((HttpClientResponse)response).compose(buffer -> {
            this.future.complete(this.createResponse((HttpClientResponse)response, buffer));
            return Future.succeededFuture();
        })).onFailure(this.future::completeExceptionally);
        CompletionStage actualFuture = this.future.whenComplete(this::afterSend);
        VertxContextExecutor.create((Context)this.transportContext.getVertxContext()).execute(this::runInVertxContext);
        return actualFuture;
    }

    protected void runInVertxContext() {
        this.sendInVertxContext().whenComplete((v, e) -> {
            if (e != null) {
                this.future.completeExceptionally((Throwable)e);
            }
            this.invocation.getInvocationStageTrace().finishConsumerSendRequest();
            this.invocation.getInvocationStageTrace().startWaitResponse();
        });
    }

    protected CompletableFuture<Void> sendInVertxContext() {
        this.httpClientRequest.setTimeout(this.invocation.getOperationMeta().getConfig().getMsRequestTimeout());
        Multimap<String, Part> uploads = this.requestParameters.getUploads();
        if (uploads == null) {
            if (this.requestParameters.getBodyBuffer() != null) {
                return CompletableFuture.completedFuture(null).thenCompose(v -> this.httpClientRequest.end(this.requestParameters.getBodyBuffer()).toCompletionStage());
            }
            return CompletableFuture.completedFuture(null).thenCompose(v -> this.httpClientRequest.end().toCompletionStage());
        }
        if (this.requestParameters.getBodyBuffer() != null) {
            this.httpClientRequest.write((Object)this.requestParameters.getBodyBuffer());
        }
        return this.sendFiles();
    }

    protected CompletableFuture<Void> sendFiles() {
        CompletionStage<Object> sendFileFuture = CompletableFuture.completedFuture(null);
        String boundary = this.transportContext.getOrCreateBoundary();
        for (Map.Entry entry : this.requestParameters.getUploads().entries()) {
            String name = (String)entry.getKey();
            sendFileFuture = sendFileFuture.thenCompose(v -> this.sendFile((Part)entry.getValue(), name, boundary));
        }
        return sendFileFuture.thenCompose(v -> this.httpClientRequest.end(RestClientEncoder.genBoundaryEndBuffer(boundary)).toCompletionStage());
    }

    private CompletableFuture<Void> sendFile(Part part, String name, String boundary) {
        Buffer fileHeader = RestClientEncoder.genFileBoundaryBuffer(part, name, boundary);
        this.httpClientRequest.write((Object)fileHeader);
        return new PumpFromPart(this.transportContext.getVertxContext(), part).toWriteStream((WriteStream)this.httpClientRequest, this.future::completeExceptionally).whenComplete((v, e) -> {
            if (e != null) {
                LOGGER.debug("Failed to send file [{}:{}].", new Object[]{name, part.getSubmittedFileName(), e});
                return;
            }
            LOGGER.debug("finish send file [{}:{}].", (Object)name, (Object)part.getSubmittedFileName());
        });
    }

    protected Future<Buffer> processResponse(HttpClientResponse httpClientResponse) {
        this.transportContext.setHttpClientResponse(httpClientResponse);
        if (HttpStatus.isSuccess((int)httpClientResponse.statusCode()) && this.transportContext.isDownloadFile()) {
            ReadStreamPart streamPart = new ReadStreamPart(this.transportContext.getVertxContext(), httpClientResponse);
            this.future.complete(this.createResponse(httpClientResponse, streamPart));
        }
        return httpClientResponse.body();
    }

    protected Response createResponse(HttpClientResponse httpClientResponse, Object result) {
        MultiMap headers = httpClientResponse.headers();
        headers.remove(":status");
        HttpStatus httpStatus = new HttpStatus(httpClientResponse.statusCode(), httpClientResponse.statusMessage());
        return Response.status((Response.StatusType)httpStatus).setHeaders(headers).entity(result);
    }

    protected void afterSend(Response response, Throwable throwable) {
        this.invocation.getInvocationStageTrace().finishWaitResponse();
        if (throwable != null) {
            LOGGER.error("rest client send or receive failed, operation={}, method={}, endpoint={}, uri={}.", new Object[]{this.invocation.getMicroserviceQualifiedName(), this.httpClientRequest.getMethod(), this.invocation.getEndpoint().getEndpoint(), this.httpClientRequest.getURI()});
        }
    }
}

