/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.DataCenterProperties;
import org.apache.servicecomb.registry.nacos.NacosDiscoveryProperties;
import org.springframework.core.env.Environment;

public class NacosMicroserviceHandler {
    private static final String VERSION_MAPPING = "VERSION_MAPPING";
    private static final String CAS_APPLICATION_ID = "CAS_APPLICATION_ID";
    private static final String CAS_COMPONENT_NAME = "CAS_COMPONENT_NAME";
    private static final String CAS_INSTANCE_VERSION = "CAS_INSTANCE_VERSION";
    private static final String CAS_INSTANCE_ID = "CAS_INSTANCE_ID";
    private static final String CAS_ENVIRONMENT_ID = "CAS_ENVIRONMENT_ID";
    private static final String INSTANCE_PROPS = "SERVICECOMB_INSTANCE_PROPS";

    public static Instance createMicroserviceInstance(DataCenterProperties dataCenterProperties, NacosDiscoveryProperties properties, Environment environment) {
        Instance instance = new Instance();
        instance.setServiceName(BootStrapProperties.readServiceName((Environment)environment));
        instance.setWeight((double)properties.getWeight());
        instance.setEnabled(properties.isInstanceEnabled());
        instance.setClusterName(properties.getClusterName());
        instance.setEphemeral(properties.isEphemeral());
        Map<String, String> metadata = properties.getMetadata();
        metadata.put("scb-version", BootStrapProperties.readServiceVersion((Environment)environment));
        metadata.put("scb-alias", BootStrapProperties.readServiceAlias((Environment)environment));
        metadata.put("scb-description", BootStrapProperties.readServiceDescription((Environment)environment));
        metadata.put("scb-datacenter", dataCenterProperties.getName());
        metadata.put("scb-region", dataCenterProperties.getRegion());
        metadata.put("scb-zone", dataCenterProperties.getAvailableZone());
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(VERSION_MAPPING)) && !StringUtils.isEmpty((CharSequence)environment.getProperty(environment.getProperty(VERSION_MAPPING)))) {
            metadata.put("version", environment.getProperty(environment.getProperty(VERSION_MAPPING)));
        }
        metadata.putAll(NacosMicroserviceHandler.genCasProperties(environment));
        instance.setMetadata(metadata);
        return instance;
    }

    private static Map<String, String> genCasProperties(Environment environment) {
        String[] instancePropArray;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_APPLICATION_ID))) {
            properties.put(CAS_APPLICATION_ID, environment.getProperty(CAS_APPLICATION_ID));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_COMPONENT_NAME))) {
            properties.put(CAS_COMPONENT_NAME, environment.getProperty(CAS_COMPONENT_NAME));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_INSTANCE_VERSION))) {
            properties.put(CAS_INSTANCE_VERSION, environment.getProperty(CAS_INSTANCE_VERSION));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_INSTANCE_ID))) {
            properties.put(CAS_INSTANCE_ID, environment.getProperty(CAS_INSTANCE_ID));
        }
        if (!StringUtils.isEmpty((CharSequence)environment.getProperty(CAS_ENVIRONMENT_ID))) {
            properties.put(CAS_ENVIRONMENT_ID, environment.getProperty(CAS_ENVIRONMENT_ID));
        }
        if ((instancePropArray = ConfigUtil.parseArrayValue((String)environment.getProperty(INSTANCE_PROPS)).toArray(new String[0])).length != 0) {
            properties.putAll(NacosMicroserviceHandler.parseProps(instancePropArray));
        }
        return properties;
    }

    private static Map<String, String> parseProps(String ... value) {
        return Arrays.stream(value).map(v -> v.split(":")).filter(v -> ((String[])v).length == 2).collect(Collectors.toMap(v -> v[0], v -> v[1]));
    }
}

