/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.solution.basic.integration;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.registry.discovery.InstancePing;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;
import org.apache.servicecomb.registry.discovery.TelnetInstancePing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class HealthInstancePing
implements InstancePing {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthInstancePing.class);
    private SCBEngine scbEngine;
    private TelnetInstancePing telnetInstancePing;

    @Autowired
    @Lazy
    public void setScbEngine(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
    }

    @Autowired
    @Lazy
    public void setTelnetInstancePing(@Qualifier(value="telnetInstancePing") TelnetInstancePing telnetInstancePing) {
        this.telnetInstancePing = telnetInstancePing;
    }

    public boolean ping(StatefulDiscoveryInstance instance) {
        if (CollectionUtils.isEmpty((Collection)instance.getEndpoints())) {
            return false;
        }
        if ("local-registry".equals(instance.getRegistryName())) {
            return this.telnetInstancePing.ping(instance);
        }
        HashMap<String, String> args = new HashMap<String, String>(2);
        args.put("instanceId", instance.getInstanceId());
        args.put("registryName", instance.getRegistryName());
        for (String endpoint : instance.getEndpoints()) {
            boolean result;
            URI uri = URI.create(endpoint);
            String transportName = uri.getScheme();
            Transport transport = this.scbEngine.getTransportManager().findTransport(transportName);
            if (transport == null) continue;
            Invocation invocation = InvokerUtils.createInvocation((String)instance.getServiceName(), (String)transportName, (String)"scb-management", (String)"health", args, Boolean.TYPE);
            invocation.setEndpoint(new Endpoint(transport, endpoint, (DiscoveryInstance)instance));
            try {
                result = (Boolean)InvokerUtils.syncInvoke((Invocation)invocation);
            }
            catch (Exception e) {
                LOGGER.warn("ping instance {}/{}/{}/{} endpoint {} failed. {}", new Object[]{instance.getApplication(), instance.getServiceName(), instance.getRegistryName(), instance.getInstanceId(), endpoint, e.getMessage()});
                continue;
            }
            if (result) {
                return true;
            }
            LOGGER.warn("ping instance {}/{}/{}/{} endpoint {} failed", new Object[]{instance.getApplication(), instance.getServiceName(), instance.getRegistryName(), instance.getInstanceId(), endpoint});
        }
        return false;
    }

    public int getOrder() {
        return -10000;
    }
}

