/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import io.vertx.core.Verticle;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.transport.common.TransportConfigUtils;
import org.apache.servicecomb.transport.rest.vertx.RestServerVerticle;

public final class TransportConfig {
    public static final int DEFAULT_SERVER_CONNECTION_IDLE_TIMEOUT_SECOND = 180;
    public static final boolean DEFAULT_SERVER_COMPRESSION_SUPPORT = false;
    public static final int DEFAULT_SERVER_MAX_HEADER_SIZE = 32768;
    public static final String SERVICECOMB_CORS_CONFIG_BASE = "servicecomb.cors";
    private static Class<? extends Verticle> restServerVerticle = RestServerVerticle.class;

    private TransportConfig() {
    }

    public static Class<? extends Verticle> getRestServerVerticle() {
        return restServerVerticle;
    }

    public static void setRestServerVerticle(Class<? extends Verticle> restServerVerticle) {
        TransportConfig.restServerVerticle = restServerVerticle;
    }

    public static String getAddress() {
        return LegacyPropertyFactory.getStringProperty((String)"servicecomb.rest.address", null);
    }

    public static int getMaxFormAttributeSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.maxFormAttributeSize", (int)8192);
    }

    public static int getCompressionLevel() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.compressionLevel", (int)6);
    }

    public static int getMaxChunkSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.maxChunkSize", (int)8192);
    }

    public static int getDecoderInitialBufferSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.decoderInitialBufferSize", (int)128);
    }

    public static int getHttp2ConnectionWindowSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.http2ConnectionWindowSize", (int)-1);
    }

    public static int getThreadCount() {
        return TransportConfigUtils.readVerticleCount((String)"servicecomb.rest.server.verticle-count", (String)"servicecomb.rest.server.thread-count");
    }

    public static int getConnectionIdleTimeoutInSeconds() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.connection.idleTimeoutInSeconds", (int)180);
    }

    public static int getHttp2ConnectionIdleTimeoutInSeconds() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.http2.connection.idleTimeoutInSeconds", (int)180);
    }

    public static boolean getCompressed() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.server.compression", (boolean)false);
    }

    public static boolean getDecompressionSupported() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.server.decompressionSupported", (boolean)false);
    }

    public static long getMaxConcurrentStreams() {
        return LegacyPropertyFactory.getLongProperty((String)"servicecomb.rest.server.http2.concurrentStreams", (long)100L);
    }

    public static long getHttp2HeaderTableSize() {
        return LegacyPropertyFactory.getLongProperty((String)"servicecomb.rest.server.http2.HeaderTableSize", (long)4096L);
    }

    public static boolean getPushEnabled() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.server.http2.pushEnabled", (boolean)true);
    }

    public static int getInitialWindowSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.http2.initialWindowSize", (int)65535);
    }

    public static int getMaxFrameSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.http2.maxFrameSize", (int)16384);
    }

    public static int getMaxHeaderListSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.http2.maxHeaderListSize", (int)8192);
    }

    public static boolean getUseAlpn() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.server.http2.useAlpnEnabled", (boolean)true);
    }

    public static int getMaxHeaderSize() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.maxHeaderSize", (int)32768);
    }

    public static boolean isCorsEnabled() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.cors.enabled", (boolean)false);
    }

    public static String getCorsAllowedOrigin() {
        return LegacyPropertyFactory.getStringProperty((String)"servicecomb.cors.origin", (String)"*");
    }

    public static boolean isCorsAllowCredentials() {
        return LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.cors.allowCredentials", (boolean)false);
    }

    public static Set<String> getCorsAllowedHeaders() {
        String allowedHeaders = LegacyPropertyFactory.getStringProperty((String)"servicecomb.cors.allowedHeader");
        return TransportConfig.convertToSet(allowedHeaders);
    }

    public static Set<String> getCorsAllowedMethods() {
        String allowedMethods = LegacyPropertyFactory.getStringProperty((String)"servicecomb.cors.allowedMethod");
        return TransportConfig.convertToSet(allowedMethods);
    }

    public static Set<String> getCorsExposedHeaders() {
        String exposedHeaders = LegacyPropertyFactory.getStringProperty((String)"servicecomb.cors.exposedHeader");
        return TransportConfig.convertToSet(exposedHeaders);
    }

    public static int getCorsMaxAge() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.cors.maxAge", (int)-1);
    }

    private static Set<String> convertToSet(String setString) {
        HashSet<String> resultSet = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)setString)) {
            String[] arrString = setString.split(",");
            Stream.of(arrString).map(String::trim).filter(str -> !StringUtils.isEmpty((CharSequence)str)).forEach(resultSet::add);
        }
        return resultSet;
    }

    public static int getMaxInitialLineLength() {
        return LegacyPropertyFactory.getIntProperty((String)"servicecomb.rest.server.maxInitialLineLength", (int)4096);
    }
}

