/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.distribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.servicecomb.router.cache.RouterRuleCache;
import org.apache.servicecomb.router.distribute.RouterDistributor;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.apache.servicecomb.router.model.RouteItem;
import org.apache.servicecomb.router.model.TagItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRouterDistributor<INSTANCE>
implements RouterDistributor<INSTANCE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRouterDistributor.class);
    private Function<INSTANCE, String> getVersion;
    private Function<INSTANCE, String> getServerName;
    private Function<INSTANCE, Map<String, String>> getProperties;
    private RouterRuleCache routerRuleCache;

    @Autowired
    public void setRouterRuleCache(RouterRuleCache routerRuleCache) {
        this.routerRuleCache = routerRuleCache;
    }

    protected AbstractRouterDistributor() {
    }

    @Override
    public List<INSTANCE> distribute(String targetServiceName, List<INSTANCE> list, PolicyRuleItem invokeRule) {
        invokeRule.check();
        ArrayList unSetTagInstances = new ArrayList();
        Map<TagItem, List<INSTANCE>> versionServerMap = this.getDistributList(targetServiceName, list, invokeRule, unSetTagInstances);
        if (CollectionUtils.isEmpty(versionServerMap)) {
            LOGGER.debug("route management can not match any rule and route the latest version");
            return list;
        }
        TagItem targetTag = this.getFiltedServerTagItem(invokeRule, targetServiceName);
        if (targetTag != null && versionServerMap.containsKey(targetTag)) {
            return versionServerMap.get(targetTag);
        }
        if (invokeRule.isWeightLess() && unSetTagInstances.size() > 0) {
            return unSetTagInstances;
        }
        return list;
    }

    @Override
    public void init(Function<INSTANCE, String> getVersion, Function<INSTANCE, String> getServerName, Function<INSTANCE, Map<String, String>> getProperties) {
        this.getVersion = getVersion;
        this.getServerName = getServerName;
        this.getProperties = getProperties;
    }

    public TagItem getFiltedServerTagItem(PolicyRuleItem rule, String targetServiceName) {
        return this.routerRuleCache.getServiceInfoCacheMap().get(targetServiceName).getNextInvokeVersion(rule);
    }

    private Map<TagItem, List<INSTANCE>> getDistributList(String serviceName, List<INSTANCE> list, PolicyRuleItem invokeRule, List<INSTANCE> unSetTagInstances) {
        HashMap<TagItem, List<INSTANCE>> versionServerMap = new HashMap<TagItem, List<INSTANCE>>();
        for (INSTANCE instance : list) {
            if (!this.getServerName.apply(instance).equals(serviceName)) continue;
            TagItem tagItem = new TagItem(this.getVersion.apply(instance), this.getProperties.apply(instance));
            TagItem targetTag = null;
            int maxMatch = 0;
            for (RouteItem entry : invokeRule.getRoute()) {
                int nowMatch;
                if (entry.getTagitem() == null || (nowMatch = entry.getTagitem().matchNum(tagItem)) <= maxMatch) continue;
                maxMatch = nowMatch;
                targetTag = entry.getTagitem();
            }
            if (targetTag != null) {
                if (!versionServerMap.containsKey(targetTag)) {
                    versionServerMap.put(targetTag, new ArrayList());
                }
                ((List)versionServerMap.get(targetTag)).add(instance);
                continue;
            }
            unSetTagInstances.add(instance);
        }
        return versionServerMap;
    }
}

