/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;
import org.apache.servicecomb.service.center.client.DiscoveryEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.model.FindMicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterDiscovery
extends AbstractTask {
    public static final int MAX_INTERVAL = 600000;
    public static final int MIN_INTERVAL = 1000;
    private static final String ALL_VERSION = "0+";
    private static volatile boolean pullInstanceTaskOnceInProgress = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterDiscovery.class);
    private final ServiceCenterClient serviceCenterClient;
    private final EventBus eventBus;
    private String myselfServiceId;
    private final Map<SubscriptionKey, SubscriptionValue> instancesCache = new ConcurrentHashMap<SubscriptionKey, SubscriptionValue>();
    private final Map<String, Microservice> microserviceCache = new ConcurrentHashMap<String, Microservice>();
    private long pollInterval = 15000L;
    private boolean started = false;
    private final Object lock = new Object();

    public ServiceCenterDiscovery(ServiceCenterClient serviceCenterClient, EventBus eventBus) {
        super("service-center-discovery-task");
        this.serviceCenterClient = serviceCenterClient;
        this.eventBus = eventBus;
        this.eventBus.register((Object)this);
    }

    public ServiceCenterDiscovery setPollInterval(long interval) {
        if (interval > 600000L || interval < 1000L) {
            return this;
        }
        this.pollInterval = interval;
        return this;
    }

    public void updateMyselfServiceId(String myselfServiceId) {
        this.myselfServiceId = myselfServiceId;
    }

    public void startDiscovery() {
        if (!this.started) {
            this.started = true;
            this.startTask(new PullInstanceTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIfNotPresent(SubscriptionKey subscriptionKey) {
        if (this.instancesCache.get(subscriptionKey) == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.instancesCache.get(subscriptionKey) == null) {
                    SubscriptionValue value = new SubscriptionValue();
                    this.pullInstance(subscriptionKey, value, false);
                    this.instancesCache.put(subscriptionKey, value);
                }
            }
        }
    }

    public List<MicroserviceInstance> getInstanceCache(SubscriptionKey key) {
        return this.instancesCache.get((Object)key).instancesCache;
    }

    @Subscribe
    public void onPullInstanceEvent(DiscoveryEvents.PullInstanceEvent event) {
        if (pullInstanceTaskOnceInProgress) {
            return;
        }
        pullInstanceTaskOnceInProgress = true;
        this.startTask(new PullInstanceOnceTask());
    }

    private List<SubscriptionKey> pullInstance(SubscriptionKey k, SubscriptionValue v, boolean sendChangedEvent) {
        ArrayList<SubscriptionKey> failedKeys;
        block5: {
            if (this.myselfServiceId == null) {
                return Collections.emptyList();
            }
            failedKeys = new ArrayList<SubscriptionKey>();
            try {
                FindMicroserviceInstancesResponse instancesResponse = this.serviceCenterClient.findMicroserviceInstance(this.myselfServiceId, k.appId, k.serviceName, ALL_VERSION, v.revision);
                if (instancesResponse.isModified()) {
                    List<MicroserviceInstance> instances = instancesResponse.getMicroserviceInstancesResponse().getInstances() == null ? Collections.emptyList() : instancesResponse.getMicroserviceInstancesResponse().getInstances();
                    this.setMicroserviceInfo(instances);
                    LOGGER.info("Instance changed event. Current: revision={}, instances={}. Origin: revision={}, instances={}. appId={}, serviceName={}.", new Object[]{instancesResponse.getRevision(), ServiceCenterDiscovery.instanceToString(instances), v.revision, ServiceCenterDiscovery.instanceToString(v.instancesCache), k.appId, k.serviceName});
                    v.instancesCache = instances;
                    v.revision = instancesResponse.getRevision();
                    if (sendChangedEvent) {
                        this.eventBus.post((Object)new DiscoveryEvents.InstanceChangedEvent(k.appId, k.serviceName, v.instancesCache));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("find service {}#{} instance failed.", new Object[]{k.appId, k.serviceName, e});
                if (e.getCause() instanceof IOException) break block5;
                failedKeys.add(k);
            }
        }
        return failedKeys;
    }

    private void setMicroserviceInfo(List<MicroserviceInstance> instances) {
        instances.forEach(instance -> {
            Microservice microservice = this.microserviceCache.computeIfAbsent(instance.getServiceId(), id -> {
                try {
                    return this.serviceCenterClient.getMicroserviceByServiceId((String)id);
                }
                catch (Exception e) {
                    LOGGER.error("Find microservice by id={} failed", id, (Object)e);
                    throw e;
                }
            });
            instance.setMicroservice(microservice);
        });
    }

    private synchronized void pullAllInstance() {
        ArrayList failedInstances = new ArrayList();
        this.instancesCache.forEach((k, v) -> failedInstances.addAll(this.pullInstance((SubscriptionKey)k, (SubscriptionValue)v, true)));
        if (failedInstances.isEmpty()) {
            return;
        }
        failedInstances.forEach(this.instancesCache::remove);
        failedInstances.clear();
    }

    private static String instanceToString(List<MicroserviceInstance> instances) {
        if (instances == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (MicroserviceInstance instance : instances) {
            for (String endpoint : instance.getEndpoints()) {
                sb.append(endpoint.length() > 64 ? endpoint.substring(0, 64) : endpoint);
                sb.append("|");
            }
        }
        return sb.toString();
    }

    class PullInstanceTask
    implements Task {
        PullInstanceTask() {
        }

        public void execute() {
            ServiceCenterDiscovery.this.pullAllInstance();
            ServiceCenterDiscovery.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterDiscovery.this, ServiceCenterDiscovery.this.pollInterval, (Task)new PullInstanceTask()));
        }
    }

    public static class SubscriptionValue {
        String revision;
        List<MicroserviceInstance> instancesCache;
    }

    public static class SubscriptionKey {
        final String appId;
        final String serviceName;

        public SubscriptionKey(String appId, String serviceName) {
            this.appId = appId;
            this.serviceName = serviceName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriptionKey that = (SubscriptionKey)o;
            return this.appId.equals(that.appId) && this.serviceName.equals(that.serviceName);
        }

        public int hashCode() {
            return Objects.hash(this.appId, this.serviceName);
        }
    }

    class PullInstanceOnceTask
    implements Task {
        PullInstanceOnceTask() {
        }

        public void execute() {
            try {
                ServiceCenterDiscovery.this.pullAllInstance();
            }
            finally {
                pullInstanceTaskOnceInProgress = false;
            }
        }
    }
}

